package ar.com.sdd.commons.util.lineparser;



/**
 * Parsea una linea en formato texto de longitud fija. Hace falta describir los nombres 
 * de los campos y especificar la longitud de c/u. 
 * Considera que todos los campos son de tipo String.
 *
 * @author Andres Ferrari.
 */
public class FixedLineParser extends LineParser {

	/**
	 * Longitud en caracteres de la linea.
	 */
	protected int recordLength;

	/**
	 * Posiciones (offsets) de cada campo, en caracteres.
	 */
	protected int[] fieldOffsets;


	//---------------------------------------------------------------------------//
	
	/**
	 * Constructor.
	 * @param fieldNames Determina los nombres de los campos asi como su cantidad.
	 * @param recordLength Longitud total de la linea, en caracteres.
	 * @param fieldOffsets Determina las posiciones (offsets en caracteres) de c/campo.
	 *					   El primer caracter de la linea se considera en la posicion 0.
	 */
	public FixedLineParser(String[] fieldNames, int recordLength, int[] fieldOffsets) {
		
		super(fieldNames);
		this.recordLength = recordLength;
		this.fieldOffsets = fieldOffsets;
		
		// Nota: deben coincidir los tama#os de los arrays, caso contrario es un error grave!
		if (fieldNames.length != fieldOffsets.length) {
			throw new RuntimeException("Error durante creacion del FixedLineParser: ambos "
									 + "arrays deben tener la misma longitud!");
		}
	}	
	
	
	/**
	 * Obtiene la longitud total del registro.
	 */
	public int getRecordLength() { return recordLength; }
	
	
	/**
	 * Devuelve el offset en caracteres del i-esimo campo.
	 * Si el offset no es valido devuelve -1.
	 */
	public int getFieldOffset(int i) {
		
		int offset = (0 <= i && i < getNumOfFields()) ? fieldOffsets[i] : -1;
		return offset;
	}
	

	/**
	 * Devuelve el offset en caracteres del campo cuyo nombre es 'fieldName'.
	 * Si el offset no es valido devuelve -1.
	 */
	public int getFieldOffset(String fieldName) {
		
		// Obtiene el indice a partir del nombre del campo
		int idx = getFieldIndex(fieldName);
		// Si el indice existe, obtengo el offset del campo; si no devuelvo -1
		int offset = (idx != -1) ? fieldOffsets[idx] : -1;
		
		return offset;
	}


	/**
	 * Parsea el String que representa un registro.
	 * @param lineBuffer linea de texto a parsear.
	 */
	public void parse(String lineBuffer) throws LineParserException {
		
		//
		// Recorre la lista de offsets y obtiene el valor para cada campo
		//
		int lastField = getNumOfFields() - 1;
		for (int i = 0; i < getNumOfFields(); i++) {
			
			int offset = fieldOffsets[i];
			
			// Obtiene la longitud del campo (si estoy en el ultimo campo,
			// se compara contra la longitud total del registro; caso contrario
			// se compara contra el siguiente offset)
			int nextOffset  = (i < lastField) ? fieldOffsets[i + 1] : recordLength;
			int fieldLength = nextOffset - offset;
			
			// Almacena en un String los caracteres en el intervalo 
			// [offset, offset + fieldLenght)  
			// OJO: no incluye el ultimo!
			String fieldValue = lineBuffer.substring(offset, offset + fieldLength);
			
			// Nota: omite espacios en blanco a izquierda y derecha
			fieldValues[i] = fieldValue.trim();
			
		}
	}
	
}