package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.ApplicationException;

@javax.ejb.ApplicationException
public class MapperException extends ApplicationException {

    private static final long serialVersionUID = 1L;
    
    private boolean fatal;

    /**
     * Constructor for DataProcessException.
     * @param msg
     */
    public MapperException(String msg, boolean fatal) {
        super(msg);
        this.fatal = fatal;
    }

    public MapperException(String msg) {
        super(msg);
        this.fatal = true;
    }
    public MapperException(String msg, Throwable ex) {
        super(msg, ex);
        this.fatal = true;
    }

    /**
     * Constructor for DataProcessException.
     * @param msg
     * @param detail
     */
    public MapperException(String msg, Throwable detail, boolean fatal) {
        super(msg, detail);
        this.fatal = fatal;
    }

    /**
     * @see ar.com.sdd.util.AbstractException#getFatal()
     */
    protected boolean getFatal() {
        return fatal;
    }

    /**
     * @see ar.com.sdd.util.AbstractException#getLoggeable()
     */
    protected boolean getLoggeable() {
        return true;
    }



}
