package ar.com.sdd.commons.util.reflection;

import ar.com.sdd.commons.util.Config;

import java.util.HashMap;
import java.util.Map;

public class MutableConfigContext implements ObjectBuilderContext {
    
    private Config config;
    private Map addedValues;
    
    public MutableConfigContext() {
        this( null );
    }

    public MutableConfigContext( Config config ) {
        this.config = config;
        this.addedValues = new HashMap();
    }

    public Object getContextValue( String key ) {
        return
            addedValues.containsKey( key ) || config == null?
                    addedValues.get( key ):
                    config.getProperty( key );
    }
    
    public void putContextValue( String key, Object value ) {
        addedValues.put( key, value );
    }

    public void removeContextValue( String key, Object value ) {
        addedValues.remove( key );
    }
    
    public void addContextValues( Map contextValues ) {
    	addedValues.putAll( contextValues );
    }

}
