package ar.com.sdd.commons.util.security;

import ar.com.sdd.commons.util.ApplicationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

import javax.xml.bind.DatatypeConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.*;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;


public class PEMEncriptionHelper {

	private static final Logger log = LogManager.getLogger(PEMEncriptionHelper.class);

	private static final int DEFAULT_CHUNK_SIZE = 1024;

	public static String generaFirma(String datos, String llavePrivadaPath) {
		log.debug("Generando firma PEM para datos [" + datos + "], llavePrivadaPath [" + llavePrivadaPath + "]");

		PEMReader reader = null;
		try {
			Security.addProvider(new BouncyCastleProvider());
			reader = new PEMReader(new InputStreamReader(new FileInputStream(llavePrivadaPath)));
			KeyPair par = (KeyPair) reader.readObject();
			PrivateKey privateKey = par.getPrivate();

			Signature sig = Signature.getInstance("MD5WithRSA");
			sig.initSign(privateKey);
			sig.update(datos.getBytes(StandardCharsets.UTF_8));

			//String firma = new BASE64Encoder().encode(sig.sign());
			String firma = DatatypeConverter.printBase64Binary(sig.sign());
			
			log.debug("Firma [" + firma + "]");

			return firma;

		} catch (Exception e) {
			throw new ApplicationException("Error al generar firma PEM para datos [" + datos + "], llavePrivadaPath [" + llavePrivadaPath + "]", e);
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException e) {
					throw new ApplicationException("Error al generar cerrar el reader en firma PEM para datos [" + datos + "], llavePrivadaPath [" + llavePrivadaPath + "]", e);
				}
			}
		}
	}

	public static boolean verificaFirma(String datos, String firma, String llavePublicaPath) {
		log.debug("Verificando firma PEM para datos [" + datos + "], firma [" + firma + "], llavePublicaPath [" + llavePublicaPath + "]");

		try {
            String key = Files.readString(new File(llavePublicaPath).toPath());
            String publicKeyPEM = key
                    .replace("-----BEGIN PUBLIC KEY-----", "")
                    .replaceAll(System.lineSeparator(), "")
                    .replace("-----END PUBLIC KEY-----", "");

            byte[] encKey = com.google.api.client.util.Base64.decodeBase64(publicKeyPEM);

			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
			PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);

			Signature sig = Signature.getInstance("MD5WithRSA");
			sig.initVerify(publicKey);
			sig.update(datos.getBytes(StandardCharsets.UTF_8));

			if (firma.contains(" ")) {
			    firma = firma.replaceAll(" ", "+");
            }

			boolean result = sig.verify(Base64.getDecoder().decode(firma));
			log.debug("Verificacion [" + result + "]");

			return result;

		} catch (Exception e) {
			log.error("Error al verificar firma PEM para datos [" + datos + "], firma [" + firma + "], llavePublicaPath [" + llavePublicaPath + "]", e);
			return false;
		}
	}

}
