package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.converter.StringToMethodNameConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Properties;


/**
 * ???
 * @author aalfonso
 */
public abstract class AbstractHandler extends DefaultHandler {

	static private final Logger log = LogManager.getLogger(AbstractHandler.class);
	
	protected LinkedList currentElement;

	
	//----------------------------------------------------------------------------//    

	public void startDocument() throws SAXException {
	    currentElement = new LinkedList();
	}


	public Object startElement( Object target,
								String uri,
								String localName,
								String qName,
								Attributes attributes)
						throws Throwable {
		    
		String tagName = getElementName(localName, qName);
		currentElement.addLast(tagName);
		String methodName = toMethodName("start-" + tagName);
		
		try {
		
			Method method =	target.getClass().getMethod(methodName,
														new Class[] { Properties.class }
														);
			return method.invoke(target, new Object[] { attributesToProperties(attributes) });
		
		} catch (java.lang.reflect.InvocationTargetException ex) {
			
			throw ex.getTargetException();
			
		} catch (IllegalAccessException ex) {
			
			throw new SAXException("No esta permitido invocar el metodo "
											  + methodName
											  + " sobre el handler",
											  ex);
											  
		} catch (NoSuchMethodException ex) {
			//no se considera un error. Simplemente se ignora.
			throw ex;
		}
	}


	public Object endElement(Object target,
							 String uri,
							 String localName,
							 String qName)
			            throws Throwable {
			            	
		String methodName =	toMethodName("end-" + getElementName(localName, qName));
		
		try {
			
			Method method = target.getClass().getMethod(methodName, new Class[] {});
			return method.invoke(target, new Object[] {});
			
		} catch (java.lang.reflect.InvocationTargetException ex) {
			
			throw ex.getTargetException();
			
		} catch (IllegalAccessException ex) {
			
			throw new SAXException("No esta permitido invocar el metodo "
											  + methodName
											  + " sobre el handler",
											  ex);
											  
		} catch (NoSuchMethodException ex) {
			
			throw ex;
			
		} finally {
			currentElement.removeLast();
		}
	}


	public Object characters(Object target,
							 char[] chars,
							 int start,
							 int length)
						throws Throwable {
							
		String localName  = (String) currentElement.getLast();
		String text 	  = new String(chars, start, length);
		String methodName = toMethodName("text-" + localName);
		
		try {
			
			Method method =	target.getClass().getMethod(methodName,
														new Class[] { String.class });
			return method.invoke(target, new Object[] { text });
			
		} catch (java.lang.reflect.InvocationTargetException ex) {
			
			throw ex.getTargetException();
			
		} catch (IllegalAccessException ex) {
			
			throw new SAXException("No esta permitido invocar el metodo "
											  + methodName
											  + " sobre el handler",
											  ex);
											  
		} catch (NoSuchMethodException ex) {
			throw ex;
		}
	}
	

	//--- Implementacion de ErrorHandler ------------------------------------------------------------------------
    
	public void warning(SAXParseException p0) throws SAXException {
		log.warn("", p0);
	}
	
	
	public void error(SAXParseException p0) throws SAXException {
		error("", p0);
	}
	
	
	public void fatalError(SAXParseException p0) throws SAXException {
		fatalError("", p0);
		throw p0;
	}
	
	
	protected void warning(String msg) {
		log.warn(msg);
	}
	
	protected void error(String string, Throwable ex) {
		log.error(string, ex);
	}
	
	protected void fatalError(String msg, Throwable ex) {
		log.fatal(msg, ex);
	}

	
	//--- Private methods ------------------------------------------------------------------------
    
	protected String toMethodName(String t) {
		return StringToMethodNameConverter.convertTo(t);
	}
	
	
	/**
	 * Este metodo pretende encapsular el moco de especificacion que tiene
	 * SAX: segun la documentacion
	 * <ul>
	 *      <li>El <b>localName</b> es obligatorio cuando la propiedad
	 *          <i>namespace</i> es <b>true</b> (el default) y es opcional cuando
	 *          la propiedad <i>namespace</i> es <b>false</b></li>
	 *      <li>El <b>qName</b> (qualified name) es obligatorio cuando la propiedad
	 *          <i>namespace-prefixes</i> es <b>true</b> y opcional en otro caso.</li>
	 * </ul>
	 */
	protected String getElementName(String localName, String qName) {
	
		return ((localName.trim().length() > 0) ? localName : qName);
	}
	
	
	protected Properties attributesToProperties(Attributes att) {
	
		int count 		= att.getLength();
		Properties prop = new Properties();
			
		for (int i = 0; i < count; i++) {
			
			String name  = getElementName(att.getLocalName(i), att.getQName(i));
			String value = att.getValue(i);
			prop.setProperty(name, value);
			
		}
			
		return prop;
	}
	
}
