package ar.com.sdd.commons.util.xml;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.LinkedList;


/**
 * ???
 * @author aalfonso
 */
public class HierarchicalHandler extends AbstractHandler {

	private LinkedList handlerStack = new LinkedList();
	private LinkedList tagStack 	= new LinkedList();

	
	//---------------------------------------------------------------------------//
    
	/**
	 * Constructor for HierarchicalHandler.
	 * @param docHandler
	 */
	public HierarchicalHandler(Object handler) {
		super();
		pushHandler(handler, "");
	}


	public void startElement(String uri, String localName, String qName, Attributes attributes) 
					throws SAXException {
						
		try {
		
			Object subHandler = startElement(currentHandler(), uri, localName, qName, attributes);
			if (subHandler != null)	pushHandler(subHandler, getElementName(localName, qName));

		} catch (Exception ex) {
			throw new SAXException(ex);
		} catch (Throwable ex) {
			error("", ex);
		}
	}


	public void endElement(String uri, String localName, String qName) 
					throws SAXException {
			
		try {
		
			endElement(currentHandler(), uri, localName, qName);
			String tagName = getElementName(localName, qName);
			if (tagName.equals(currentHandlerRootTag())) popHandler();
		
		} catch (Exception ex) {
			throw new SAXException(ex);
		} catch (Throwable ex) {
			error("", ex);
		}
	}


	public void characters(char[] chars, int start, int length) 
					throws SAXException {
						
		try {
			characters(currentHandler(), chars, start, length);
		} catch (Exception ex) {
			throw new SAXException(ex);
		} catch (Throwable ex) {
			error("", ex);
		}
	}
		
		
	private void pushHandler(Object handler, String tag) {
		tagStack.addFirst(tag);
		handlerStack.addFirst(handler);
	}
    

	private Object popHandler() {
		tagStack.removeFirst();
		return handlerStack.removeFirst();
	}
		

	private Object currentHandler() {
		return handlerStack.getFirst();
	}
		

	private String currentHandlerRootTag() {
		return (String)tagStack.getFirst();
	}

}
