package ar.com.sdd.commons.util.xml;

import org.xml.sax.Attributes;

import java.util.LinkedList;

/**
 * Extiende a <code>org.xml.sax.helpers.DefaultHandler</code> y utiliza un
 * objeto arbitrario como <code>ContentHandler</code>. Para esto genera una
 * invocacion a un metodo determinado del objeto (a traves de Reflexion) ante
 * cada evento que recibe.
 * <p>
 * <b>Elementos</b>:<br>
 * Los eventos <code>startElement</code> y <code>endElement</code> generan
 * llamadas a los metodos <code>start<i>NombreElemento</i></code> y
 * <code>end<i>NombreElemento</i></code>, respectivamente.<br>
 * Por ejemplo, si se encuentra el tag <code>&lt;mi-tag&gt;</code>, se llama al
 * metodo <code>startMiTag</code>. Si se encuentra el tag <code>&lt;/mi-tag&gt;</code>,
 * se llama al metodo <code>endMiTag</code>. Es decir, los "-" son eliminados y
 * las distintas palabras que componen el nombre se concatenan cambiando la primera
 * letra por una mayuscula.
 * <p>
 * Los atributos de un elemento se reciben como un parametro de tipo
 * <code>java.util.Properties</code> en el metodo <code>start<i>NombreElemento</i></code>
 * (este parametro debe estar siempre, aunque el elemento no contenga atributos).<br>
 * Por ejemplo, si en tag anterior tuviera un atributo "nombre":
 * <pre>
 *      &lt;mi-tag  nombre="un nombre"&gt; texto....  &lt;/mi-tag&gt;
 * </pre>
 * En el metodo <code>startMiTag</code> se recibira un <code>Properties</code> con
 * el siguiente par propiedad-valor:
 * <pre>
 *      propiedad: "nombre"
 *      valor: "un nombre"
 * </pre>
 * <p>
 * El texto incluido dentro de un elemento, sera reportado en una o mas invocaciones
 * al metodo <code>text<i>NombreElemento</i></code>, cuyo unico parametro debe
 * ser un <code>String</code> (que contendra el texto propiamente dicho). Los
 * casos en los que puede haber mas de una invocacion a este metodo para el mismo
 * elemento son aquellos en los que el texto tiene intercalados otros elementos.
 * En esos casos, se realiza exactamente una invocacion para cada porcion de texto
 * entre elementos que se encuentre. Por ejemplo, la siguiente porcion de XML
 * genera 2 invocaciones al metodo <code>textMiTag</code>:
 * <pre>
 *      &lt;mi-tag  nombre="un nombre"&gt;
 *          Aca empieza el texto &lt;otro-elemento&gt;datos del otro elemento &lt;/otro-elemento&gt;
 *          Aca sigue el texto de mi-tag.
 *      &lt;/mi-tag&gt;
 * </pre>
 */
public class SimpleHandler extends AbstractHandler {
	
	private Object docHandler;
	private LinkedList currentElement;


	//---------------------------------------------------------------------------//

	public SimpleHandler(Object docHandler) {
	    this.docHandler = docHandler;
	}


	public void startElement(String uri, String localName, String qName, Attributes attributes) 
					throws org.xml.sax.SAXException {
			
		try {
			super.startElement(docHandler, uri, localName, qName, attributes);
		} catch (Exception ex) {
			throw new org.xml.sax.SAXException(ex);            
		} catch (Throwable ex) {
			this.error("", ex);
		}
	}
	
	
	public void endElement(String uri, String localName, String qName) 
					throws org.xml.sax.SAXException {
	
		try {
			super.endElement(docHandler, uri, localName, qName);
		} catch (Exception ex) {
			throw new org.xml.sax.SAXException(ex);            
		} catch (Throwable ex) {
			this.error("", ex);
		}
	}

	
	public void characters(char[] chars, int start, int length) 
					throws org.xml.sax.SAXException {
	
		try {
			super.characters(docHandler, chars, start, length);
		} catch (Exception ex) {
			throw new org.xml.sax.SAXException(ex);            
		} catch (Throwable ex) {
			this.error("", ex);
		}
	}

}