package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.AbstractException;

/**
 * @author aalfonso
 * @version Aug 13, 2002-12:48:47 PM
 */
public class XMLDataException extends AbstractException {

    private static final long serialVersionUID = -8631654160660859797L;
	private boolean fatal;

    /**
     * Constructor for XMLDataException.
     * @param msg
     */
    public XMLDataException(String msg, boolean fatal) {
        super(msg);
        this.fatal = fatal;
    }

    /**
     * Constructor for XMLDataException.
     * @param msg
     * @param detail
     */
    public XMLDataException(String msg, Throwable detail, boolean fatal) {
        super(msg, detail);
        this.fatal = fatal;
    }

    /**
     * @see ar.com.sdd.util.AbstractException#getFatal()
     */
    protected boolean getFatal() {
        return fatal;
    }

    /**
     * @see ar.com.sdd.util.AbstractException#getLoggeable()
     */
    protected boolean getLoggeable() {
        return true;
    }

}
