package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.StringUtil;
import org.xml.sax.helpers.DefaultHandler;

import java.util.ArrayList;
import java.util.Enumeration;


/**
 * Base de la cual derivan todos los handlers especificos por biller.
 *
 * @author Andres Ferrari
 */
public class XMLDataHandler extends DefaultHandler implements java.io.Serializable {
	
	private static final long serialVersionUID = -3552009072082824858L;
	private XMLTag currentTree = null;
	
	
	//----------------------------------------------------------------------------//
	
	public XMLDataHandler() {}
	
	
 	public XMLTag getCurrentTree() { return currentTree; }
	public void setCurrentTree(XMLTag tree) { this.currentTree = tree; }


    protected ArrayList<XMLTag> sortById(Enumeration tags) {
        ArrayList<XMLTag> sortedTags = new ArrayList<>();

        while(tags.hasMoreElements()) {
            XMLTag tag = (XMLTag) tags.nextElement();
            sortedTags.add(tag);
        }

        sortedTags.sort((o1, o2) -> {
            int result = 0;
            if (o1 != null && o2 != null) {
                if (!StringUtil.isEmpty(o1.getProperty("id")) && !StringUtil.isEmpty(o2.getProperty("id"))) {
                    return Integer.valueOf(o1.getProperty("id")).compareTo(Integer.valueOf(o2.getProperty("id")));
                }
            }
            return result;
        });

        return sortedTags;
    }
}
