/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class FixedFormatter {
    List fields = new ArrayList();
    boolean throwExceptionOnDataLost = false;
    boolean compiled = false;
    int resultLenght;
    int[] fieldLenght;
    String[] fieldPaddingType;
    char[] fieldPaddingChar;

    public void addField(int length) {
        this.addField(length, "PADD_RIGHT", ' ');
    }

    public void addField(int length, String paddingType) {
        this.addField(length, paddingType, ' ');
    }

    public void addField(int length, String paddingType, char paddingChar) {
        this.compiled = false;
        this.fields.add(new Object[]{length, paddingType, Character.valueOf(paddingChar)});
    }

    public void setThrowExceptionOnDataLost(boolean throwExceptionOnDataLost) {
        this.throwExceptionOnDataLost = throwExceptionOnDataLost;
    }

    private void compile() {
        this.resultLenght = 0;
        this.fieldLenght = new int[this.fields.size()];
        this.fieldPaddingType = new String[this.fields.size()];
        this.fieldPaddingChar = new char[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            Object[] tok = (Object[])this.fields.get(i);
            int length = (Integer)tok[0];
            this.resultLenght += length;
            this.fieldLenght[i] = length;
            this.fieldPaddingType[i] = (String)tok[1];
            this.fieldPaddingChar[i] = ((Character)tok[2]).charValue();
        }
        this.compiled = true;
    }

    public String format(Object[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!this.compiled) {
            this.compile();
        }
        StringBuilder str = new StringBuilder(this.resultLenght);
        for (int i = 0; i < this.fields.size(); ++i) {
            String s;
            Object v = null;
            if (i < array.length) {
                v = array[i];
            }
            if ((s = v instanceof String ? (String)v : v.toString()) != null && this.throwExceptionOnDataLost && s.length() > this.fieldLenght[i]) {
                throw new RuntimeException("Campo " + i + " excede el tama#o previsto.");
            }
            s = StringUtil.padd(s, this.fieldLenght[i], this.fieldPaddingChar[i], this.fieldPaddingType[i]);
            str.append(s);
        }
        return str.toString();
    }
}

