/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

public class NumberParser {
    String signo;
    String parteEntera;
    String parteDecimal;

    public NumberParser(float num, int numBase) {
        this((double)num, numBase);
    }

    public NumberParser(double num, int numBase) {
        boolean signoMenos = num < 0.0;
        long numInt = num > 0.0 ? (long)Math.floor(num * (double)numBase + 0.50000000001) : (long)Math.ceil(num * (double)numBase - 0.50000000001);
        long cents = Math.abs(numInt % (long)numBase);
        if ((numInt /= (long)numBase) == 0L && cents == 0L) {
            signoMenos = false;
        }
        String numStr = Long.toString(numInt);
        Object centsStr = Long.toString(cents);
        if (cents < (long)(numBase / 10)) {
            centsStr = "0" + (String)centsStr;
        }
        if (signoMenos && numInt != 0L) {
            numStr = numStr.substring(1, numStr.length());
        }
        this.signo = signoMenos ? "-" : "";
        this.parteEntera = this.signo + numStr;
        this.parteDecimal = centsStr;
    }

    public String getSigno() {
        return this.signo;
    }

    public String getParteEntera() {
        return this.parteEntera;
    }

    public String getParteDecimal() {
        return this.parteDecimal;
    }

    public String format() {
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parteDecimal == null ? 0 : this.parteDecimal.hashCode());
        result = 31 * result + (this.parteEntera == null ? 0 : this.parteEntera.hashCode());
        result = 31 * result + (this.signo == null ? 0 : this.signo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberParser other = (NumberParser)obj;
        if (this.parteDecimal == null ? other.parteDecimal != null : !this.parteDecimal.equals(other.parteDecimal)) {
            return false;
        }
        if (this.parteEntera == null ? other.parteEntera != null : !this.parteEntera.equals(other.parteEntera)) {
            return false;
        }
        return !(this.signo == null ? other.signo != null : !this.signo.equals(other.signo));
    }
}

