/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.NumberParser;
import ar.com.sdd.commons.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NumberToText {
    private static int flag;
    private static String num;
    private static String num_letra;
    private static String num_letras;
    private static String num_letram;
    private static String num_letradm;
    private static String num_letracm;
    private static String num_letramm;
    private static String num_letradmm;
    private static String num_letracmm;
    private static final Logger log;

    private NumberToText() {
        flag = 0;
    }

    private static String unidad(int numero) {
        switch (numero) {
            case 9: {
                num = "nueve";
                break;
            }
            case 8: {
                num = "ocho";
                break;
            }
            case 7: {
                num = "siete";
                break;
            }
            case 6: {
                num = "seis";
                break;
            }
            case 5: {
                num = "cinco";
                break;
            }
            case 4: {
                num = "cuatro";
                break;
            }
            case 3: {
                num = "tres";
                break;
            }
            case 2: {
                num = "dos";
                break;
            }
            case 1: {
                if (flag == 0) {
                    num = "uno";
                    break;
                }
                num = "un";
                break;
            }
            case 0: {
                num = "";
                break;
            }
            default: {
                num = "";
            }
        }
        return num;
    }

    private static String decena(int numero) {
        if (numero >= 90 && numero <= 99) {
            num_letra = "noventa ";
            if (numero > 90) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 90));
            }
        } else if (numero >= 80 && numero <= 89) {
            num_letra = "ochenta ";
            if (numero > 80) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 80));
            }
        } else if (numero >= 70 && numero <= 79) {
            num_letra = "setenta ";
            if (numero > 70) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 70));
            }
        } else if (numero >= 60 && numero <= 69) {
            num_letra = "sesenta ";
            if (numero > 60) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 60));
            }
        } else if (numero >= 50 && numero <= 59) {
            num_letra = "cincuenta ";
            if (numero > 50) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 50));
            }
        } else if (numero >= 40 && numero <= 49) {
            num_letra = "cuarenta ";
            if (numero > 40) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 40));
            }
        } else if (numero >= 30 && numero <= 39) {
            num_letra = "treinta ";
            if (numero > 30) {
                num_letra = num_letra.concat("y ").concat(NumberToText.unidad(numero - 30));
            }
        } else if (numero >= 20 && numero <= 29) {
            num_letra = numero == 20 ? "veinte " : "veinti".concat(NumberToText.unidad(numero - 20));
        } else if (numero >= 10 && numero <= 19) {
            int intNum = numero;
            switch (intNum) {
                case 10: {
                    num_letra = "diez ";
                    break;
                }
                case 11: {
                    num_letra = "once ";
                    break;
                }
                case 12: {
                    num_letra = "doce ";
                    break;
                }
                case 13: {
                    num_letra = "trece ";
                    break;
                }
                case 14: {
                    num_letra = "catorce ";
                    break;
                }
                case 15: {
                    num_letra = "quince ";
                    break;
                }
                case 16: {
                    num_letra = "dieciseis ";
                    break;
                }
                case 17: {
                    num_letra = "diecisiete ";
                    break;
                }
                case 18: {
                    num_letra = "dieciocho ";
                    break;
                }
                case 19: {
                    num_letra = "diecinueve ";
                    break;
                }
                default: {
                    num_letra = "";
                    break;
                }
            }
        } else {
            num_letra = NumberToText.unidad(numero);
        }
        return num_letra;
    }

    private static String centena(int numero) {
        if (numero >= 100) {
            if (numero >= 900 && numero <= 999) {
                num_letra = "novecientos ";
                if (numero > 900) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 900));
                }
            } else if (numero >= 800 && numero <= 899) {
                num_letra = "ochocientos ";
                if (numero > 800) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 800));
                }
            } else if (numero >= 700 && numero <= 799) {
                num_letra = "setecientos ";
                if (numero > 700) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 700));
                }
            } else if (numero >= 600 && numero <= 699) {
                num_letra = "seiscientos ";
                if (numero > 600) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 600));
                }
            } else if (numero >= 500 && numero <= 599) {
                num_letra = "quinientos ";
                if (numero > 500) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 500));
                }
            } else if (numero >= 400 && numero <= 499) {
                num_letra = "cuatrocientos ";
                if (numero > 400) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 400));
                }
            } else if (numero >= 300 && numero <= 399) {
                num_letra = "trescientos ";
                if (numero > 300) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 300));
                }
            } else if (numero >= 200 && numero <= 299) {
                num_letra = "doscientos ";
                if (numero > 200) {
                    num_letra = num_letra.concat(NumberToText.decena(numero - 200));
                }
            } else if (numero >= 100 && numero <= 199) {
                num_letra = numero == 100 ? "cien " : "ciento ".concat(NumberToText.decena(numero - 100));
            }
        } else {
            num_letra = NumberToText.decena(numero);
        }
        return num_letra;
    }

    private static String miles(int numero) {
        if (numero >= 1000 && numero < 2000) {
            num_letram = "mil ".concat(NumberToText.centena(numero % 1000));
        }
        if (numero >= 2000 && numero < 10000) {
            flag = 1;
            num_letram = NumberToText.unidad(numero / 1000).concat(" mil ").concat(NumberToText.centena(numero % 1000));
        }
        if (numero < 1000) {
            num_letram = NumberToText.centena(numero);
        }
        return num_letram;
    }

    private static String decmiles(int numero) {
        if (numero == 10000) {
            num_letradm = "diez mil";
        }
        if (numero > 10000 && numero < 20000) {
            flag = 1;
            num_letradm = NumberToText.decena(numero / 1000).concat(" mil ").concat(NumberToText.centena(numero % 1000));
        }
        if (numero >= 20000 && numero < 100000) {
            flag = 1;
            num_letradm = NumberToText.decena(numero / 1000).concat(" mil ").concat(NumberToText.miles(numero % 1000));
        }
        if (numero < 10000) {
            num_letradm = NumberToText.miles(numero);
        }
        return num_letradm;
    }

    private static String cienmiles(long numero) {
        if (numero == 100000L) {
            num_letracm = "cien mil";
        }
        if (numero >= 100000L && numero < 1000000L) {
            flag = 1;
            num_letracm = NumberToText.centena((int)numero / 1000).concat(" mil ").concat(NumberToText.centena((int)numero % 1000));
        }
        if (numero < 100000L) {
            num_letracm = NumberToText.decmiles((int)numero);
        }
        return num_letracm;
    }

    private static String millon(long numero) {
        if (numero >= 1000000L && numero < 2000000L) {
            flag = 1;
            num_letramm = "Un millon ".concat(NumberToText.cienmiles(numero % 1000000L));
        }
        if (numero >= 2000000L && numero < 10000000L) {
            flag = 1;
            num_letramm = NumberToText.unidad((int)numero / 1000000).concat(" millones ").concat(NumberToText.cienmiles(numero % 1000000L));
        }
        if (numero < 1000000L) {
            num_letramm = NumberToText.cienmiles(numero);
        }
        return num_letramm;
    }

    private static String decmillon(long numero) {
        if (numero == 10000000L) {
            num_letradmm = "diez millones";
        }
        if (numero > 10000000L && numero < 20000000L) {
            flag = 1;
            num_letradmm = NumberToText.decena((int)numero / 1000000).concat(" millones ").concat(NumberToText.cienmiles(numero % 1000000L));
        }
        if (numero >= 20000000L && numero < 100000000L) {
            flag = 1;
            num_letradmm = NumberToText.decena((int)numero / 1000000).concat(" millones ").concat(NumberToText.millon(numero % 1000000L));
        }
        if (numero < 10000000L) {
            num_letradmm = NumberToText.millon(numero);
        }
        return num_letradmm;
    }

    private static String cenmillon(long numero) {
        if (numero == 100000000L) {
            num_letracmm = "cien millones";
        }
        if (numero > 100000000L && numero < 200000000L) {
            flag = 1;
            num_letracmm = NumberToText.centena((int)numero / 1000000).concat(" millones ").concat(NumberToText.millon(numero % 1000000L));
        }
        if (numero >= 200000000L && numero < 1000000000L) {
            flag = 1;
            num_letracmm = NumberToText.centena((int)numero / 1000000).concat(" millones ").concat(NumberToText.decmillon(numero % 1000000L));
        }
        if (numero == 0L) {
            num_letracmm = "cero";
        } else if (numero < 100000000L) {
            num_letracmm = NumberToText.decmillon(numero);
        }
        return num_letracmm;
    }

    public static String convertirLetras(double numero) {
        return NumberToText.convertirLetras(numero, "/100");
    }

    public static String convertirLetras(double numero, String centavosText) {
        try {
            if (numero < 0.0) {
                if (numero < -9.99999999E8) {
                    return "##Numero negativo demasiado grande##";
                }
                String positivo = NumberToText.convertirLetras(-numero);
                return "(menos)" + positivo;
            }
            if (numero > 9.99999999E8) {
                return "##Numero demasiado grande##";
            }
            NumberParser np = new NumberParser(numero, 100);
            long parteEntera = Long.parseLong(np.getParteEntera());
            num_letras = NumberToText.cenmillon(parteEntera);
            num_letras = num_letras.substring(0, 1).toUpperCase() + num_letras.substring(1);
            if (!StringUtil.isEmpty((String)centavosText) && ((String)centavosText).startsWith("_")) {
                centavosText = " " + ((String)centavosText).substring(1);
            }
            num_letras = num_letras + " con " + np.getParteDecimal() + (String)centavosText;
            return num_letras;
        }
        catch (Exception e) {
            log.error("Exepcion en NumberToText: " + e.toString(), (Throwable)e);
            return "##ERROR##";
        }
    }

    static {
        log = LogManager.getLogger(NumberToText.class);
    }
}

