/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.NumberParser;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.id.Id;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class NumberUtil {
    public static double CASI_CERO = 1.0E-6;
    public static final int BIGDECIMAL_SCALE = 2;
    public static final int BIGDECIMAL_SCALETC = 5;
    public static final BigDecimal ZERO_SCALED = BigDecimal.ZERO.setScale(2);
    public static final BigDecimal ZERO_SCALEDTC = BigDecimal.ZERO.setScale(5);
    public static final BigDecimal ONE_SCALED = BigDecimal.ONE.setScale(2);
    public static final BigDecimal ONE_SCALEDTC = BigDecimal.ONE.setScale(5);
    public static final BigDecimal MINUS_ONE_SCALED = BigDecimal.ONE.setScale(2).negate();
    public static final BigDecimal CIEN_SCALED = NumberUtil.newBigDecimal("100");
    private static DecimalFormat dfES = null;
    private static DecimalFormat dfUS = null;

    public static boolean floatIgual(float a, float b) {
        if (a == b) {
            return true;
        }
        NumberParser npa = new NumberParser(a, 100);
        NumberParser npb = new NumberParser(b, 100);
        return npa.equals(npb);
    }

    public static boolean floatMayor(float a, float b) {
        return !NumberUtil.floatIgual(a, b) && a > b;
    }

    public static boolean floatMayorOIgual(float a, float b) {
        return NumberUtil.floatIgual(a, b) || a > b;
    }

    public static boolean floatMenor(float a, float b) {
        return !NumberUtil.floatIgual(a, b) && a < b;
    }

    public static boolean floatMenorOIgual(float a, float b) {
        return NumberUtil.floatIgual(a, b) || a < b;
    }

    public static boolean doubleIgual(double a, double b) {
        if (a == b) {
            return true;
        }
        NumberParser npa = new NumberParser(a, 100);
        NumberParser npb = new NumberParser(b, 100);
        return npa.equals(npb);
    }

    public static boolean doubleDistinto(double a, double b) {
        return !NumberUtil.doubleIgual(a, b);
    }

    public static boolean isZero(double a) {
        return NumberUtil.doubleIgual(a, 0.0);
    }

    public static boolean isNotZero(double a) {
        return !NumberUtil.doubleIgual(a, 0.0);
    }

    public static boolean doubleMayor(double a, double b) {
        return !NumberUtil.doubleIgual(a, b) && a > b;
    }

    public static boolean doubleMayorOIgual(double a, double b) {
        return NumberUtil.doubleIgual(a, b) || a > b;
    }

    public static boolean doubleMenor(double a, double b) {
        return !NumberUtil.doubleIgual(a, b) && a < b;
    }

    public static boolean doubleMenorOIgual(double a, double b) {
        return NumberUtil.doubleIgual(a, b) || a < b;
    }

    public static int doubleSign(double a) {
        if (NumberUtil.doubleIgual(a, 0.0)) {
            return 0;
        }
        if (a > 0.0) {
            return 1;
        }
        return -1;
    }

    public static int doubleSignCeroPositive(double a) {
        int sign = NumberUtil.doubleSign(a);
        if (sign == 0) {
            return 1;
        }
        return sign;
    }

    public static boolean bigDecimalIgual(BigDecimal a, BigDecimal b) {
        return NumberUtil.bigDecimalIgual(a, b, CASI_CERO);
    }

    public static boolean bigDecimalIgual(BigDecimal a, BigDecimal b, double tolerance) {
        return a.subtract(b).abs().doubleValue() <= tolerance;
    }

    public static boolean isZero(BigDecimal a) {
        return NumberUtil.bigDecimalIgual(a, ZERO_SCALED);
    }

    public static boolean isNotZero(BigDecimal a) {
        return !NumberUtil.isZero(a);
    }

    public static boolean bigDecimalZero(BigDecimal a) {
        return a.abs().doubleValue() <= CASI_CERO;
    }

    public static boolean bigDecimalMayor(BigDecimal a, BigDecimal b) {
        return !NumberUtil.bigDecimalIgual(a, b) && a.compareTo(b) > 0;
    }

    public static boolean bigDecimalMayor(BigDecimal a, BigDecimal b, double tolerance) {
        return !NumberUtil.bigDecimalIgual(a, b, tolerance) && a.compareTo(b) > 0;
    }

    public static boolean bigDecimalMayorOIgual(BigDecimal a, BigDecimal b) {
        return NumberUtil.bigDecimalIgual(a, b) || a.compareTo(b) > 0;
    }

    public static boolean bigDecimalMayorOIgual(BigDecimal a, BigDecimal b, double tolerance) {
        return NumberUtil.bigDecimalIgual(a, b, tolerance) || a.compareTo(b) > 0;
    }

    public static boolean bigDecimalMenor(BigDecimal a, BigDecimal b) {
        return !NumberUtil.bigDecimalIgual(a, b) && a.compareTo(b) < 0;
    }

    public static boolean bigDecimalMenor(BigDecimal a, BigDecimal b, double tolerance) {
        return !NumberUtil.bigDecimalIgual(a, b, tolerance) && a.compareTo(b) < 0;
    }

    public static boolean bigDecimalMenor(BigDecimal a, Integer b) {
        return NumberUtil.bigDecimalMenor(a, new BigDecimal(b));
    }

    public static boolean bigDecimalMenorOIgual(BigDecimal a, BigDecimal b) {
        return NumberUtil.bigDecimalIgual(a, b) || a.compareTo(b) < 0;
    }

    public static boolean bigDecimalMenorOIgual(BigDecimal a, BigDecimal b, double tolerance) {
        return NumberUtil.bigDecimalIgual(a, b, tolerance) || a.compareTo(b) < 0;
    }

    public static int bigDecimalSign(BigDecimal a) {
        if (NumberUtil.bigDecimalIgual(a, new BigDecimal(0))) {
            return 0;
        }
        if (a.compareTo(new BigDecimal(0)) > 0) {
            return 1;
        }
        return -1;
    }

    public static String zeroFill(long value, int length) {
        StringBuilder result = new StringBuilder(String.valueOf(value));
        while (result.length() < length) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public static String toString(double a) {
        return NumberUtil.toBigDecimal(a).toString();
    }

    public static BigDecimal newBigDecimal() {
        return NumberUtil.newBigDecimal(2);
    }

    public static BigDecimal newBigDecimal(int scale) {
        return NumberUtil.newBigDecimal("0", scale);
    }

    public static BigDecimal newBigDecimal(String value) {
        return NumberUtil.newBigDecimal(value, 2);
    }

    public static BigDecimal newBigDecimal(BigDecimal value) {
        return NumberUtil.newBigDecimal(value.toString(), 2);
    }

    public static BigDecimal newBigDecimal(String value, int scale) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal toBigDecimal(double a) {
        return NumberUtil.toBigDecimal(a, 2);
    }

    public static BigDecimal toBigDecimalTC(double a) {
        return NumberUtil.toBigDecimal(a, 5);
    }

    public static BigDecimal toBigDecimal(double a, int scale) {
        return new BigDecimal(Double.toString(a)).setScale(scale, RoundingMode.HALF_UP);
    }

    public static String formatNumber(double number, int scale) {
        return NumberUtil.toBigDecimal(number, scale).toString();
    }

    public static String formatNumber(double number, int integerSize, int scale) {
        return StringUtil.padNum(NumberUtil.formatNumber(number, scale), integerSize + scale);
    }

    public static String formatNumber(double number, int scale, String formatES_US) {
        return NumberUtil.formatNumber(number, scale, formatES_US, false);
    }

    public static String formatNumber(double number, int scale, String formatES_US, boolean useGrouping) {
        BigDecimal scaled = NumberUtil.toBigDecimal(number, scale);
        Locale locale = formatES_US.equals("es") ? new Locale("es", "AR") : (formatES_US.equals("us") ? Locale.US : Locale.US);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMinimumFractionDigits(scale);
        numberFormat.setGroupingUsed(useGrouping);
        return numberFormat.format(scaled);
    }

    public static double round(double number, int numDec) {
        BigDecimal bd = new BigDecimal(number);
        return bd.setScale(numDec, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static double trunc(double number, int numDec) {
        BigDecimal bd = new BigDecimal(number);
        return bd.setScale(numDec, RoundingMode.DOWN).doubleValue();
    }

    public static String safeLong(String longCandidate, boolean failOnNonNumeric) {
        if (StringUtil.isEmpty(longCandidate)) {
            return "0";
        }
        char[] digits = longCandidate.toCharArray();
        for (int i = 0; i < digits.length; ++i) {
            if (Character.isDigit(digits[i])) continue;
            if (failOnNonNumeric) {
                throw new IllegalArgumentException("El caracter '" + digits[i] + "' no es un digito valido");
            }
            digits[i] = 48;
        }
        return new String(digits);
    }

    public static int parseInt(String inputValue, int defaultValue) {
        int retorno;
        if (StringUtil.isEmptyNull(inputValue)) {
            return defaultValue;
        }
        try {
            retorno = Integer.parseInt(inputValue);
        }
        catch (Exception e) {
            retorno = defaultValue;
        }
        return retorno;
    }

    public static long parseLong(String inputValue, long defaultValue) {
        long retorno;
        if (StringUtil.isEmptyNull(inputValue)) {
            return defaultValue;
        }
        try {
            retorno = Long.parseLong(inputValue);
        }
        catch (Exception e) {
            retorno = defaultValue;
        }
        return retorno;
    }

    public static double parseDouble(String inputValue, double defaultValue) {
        double retorno;
        if (StringUtil.isEmptyNull(inputValue)) {
            return defaultValue;
        }
        try {
            retorno = Double.parseDouble(inputValue);
        }
        catch (Exception e) {
            retorno = defaultValue;
        }
        return retorno;
    }

    public static BigDecimal parseNumber(String text, String formatES_US) {
        if ("es".equalsIgnoreCase(formatES_US)) {
            return NumberUtil.parseNumberES(text);
        }
        if ("us".equalsIgnoreCase(formatES_US)) {
            return NumberUtil.parseNumberUS(text);
        }
        return ZERO_SCALED;
    }

    public static BigDecimal parseNumberES(String text) {
        int sign = 1;
        if (text.contains("-")) {
            sign = -1;
            text = StringUtil.replace(text, "-", "");
        }
        if (dfES == null) {
            dfES = new DecimalFormat();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(',');
            symbols.setGroupingSeparator('.');
            dfES.setDecimalFormatSymbols(symbols);
        }
        try {
            return new BigDecimal(dfES.parse(text).doubleValue() * (double)sign);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal parseNumberUS(String text) {
        int sign = 1;
        if (text.contains("-")) {
            sign = -1;
            text = StringUtil.replace(text, "-", "");
        }
        if (dfUS == null) {
            dfUS = new DecimalFormat();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(',');
            dfUS.setDecimalFormatSymbols(symbols);
        }
        try {
            return new BigDecimal(dfUS.parse(text).doubleValue() * (double)sign);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static double safeDoubleValue(Double value, double defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static double safeDoubleValue(BigDecimal value, double defaultValue) {
        if (value != null) {
            return value.doubleValue();
        }
        return defaultValue;
    }

    public static BigDecimal addToBigDecimal(double value1, double value2) {
        return NumberUtil.toBigDecimal(value1).add(NumberUtil.toBigDecimal(value2));
    }

    public static BigDecimal addToBigDecimal(double value1, BigDecimal value2) {
        return NumberUtil.addToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal addToBigDecimal(double value1, BigDecimal value2, int scale) {
        return NumberUtil.toBigDecimal(value1, scale).add(value2);
    }

    public static BigDecimal subToBigDecimal(double value1, BigDecimal value2) {
        return NumberUtil.subToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal subToBigDecimal(double value1, BigDecimal value2, int scale) {
        return NumberUtil.toBigDecimal(value1, scale).subtract(value2);
    }

    public static BigDecimal subToBigDecimal(double value1, double value2) {
        return NumberUtil.toBigDecimal(value1).subtract(NumberUtil.toBigDecimal(value2));
    }

    public static BigDecimal divideToBigDecimal(double value1, BigDecimal value2) {
        return NumberUtil.divideToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal divideToBigDecimal(double value1, BigDecimal value2, int scale) {
        return NumberUtil.toBigDecimal(value1, scale).divide(value2, RoundingMode.HALF_UP);
    }

    public static BigDecimal divideToBigDecimal(BigDecimal value1, double value2) {
        return NumberUtil.divideToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal divideToBigDecimal(BigDecimal value1, double value2, int scale) {
        return value1.divide(NumberUtil.toBigDecimal(value2, scale), RoundingMode.HALF_UP);
    }

    public static BigDecimal divideToBigDecimal(BigDecimal value1, BigDecimal value2) {
        return value1.divide(value2, RoundingMode.HALF_UP);
    }

    public static BigDecimal divideToBigDecimal(double value1, double value2) {
        return NumberUtil.divideToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal divideToBigDecimal(double value1, double value2, int scale) {
        return NumberUtil.toBigDecimal(value1, scale).divide(NumberUtil.toBigDecimal(value2, scale), RoundingMode.HALF_UP);
    }

    public static BigDecimal multiplyToBigDecimal(double value1, BigDecimal value2) {
        return NumberUtil.multiplyToBigDecimal(value1, value2, 2);
    }

    public static BigDecimal multiplyToBigDecimal(double value1, BigDecimal value2, int scale) {
        return NumberUtil.toBigDecimal(value1, scale).multiply(value2).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiplyToBigDecimal(BigDecimal value1, BigDecimal value2, int scale) {
        return value1.multiply(value2).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiplyToBigDecimal(BigDecimal value1, BigDecimal value2) {
        return value1.multiply(value2).setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiplyToBigDecimal(double value1, double value2) {
        return NumberUtil.toBigDecimal(value1).multiply(NumberUtil.toBigDecimal(value2)).setScale(2, RoundingMode.HALF_UP);
    }

    public static double addToDouble(double value1, BigDecimal value2) {
        return NumberUtil.addToDouble(value1, value2, 2);
    }

    public static double addToDouble(double value1, BigDecimal value2, int scale) {
        return NumberUtil.addToBigDecimal(value1, value2, scale).doubleValue();
    }

    public static double subToDouble(double value1, BigDecimal value2) {
        return NumberUtil.subToBigDecimal(value1, value2).doubleValue();
    }

    public static Double nvl(Double valor, Double valorDefault) {
        return valor != null ? valor : valorDefault;
    }

    public static BigDecimal nvl(Double valor, BigDecimal valorDefault) {
        return valor != null ? NumberUtil.toBigDecimal(valor) : valorDefault;
    }

    public static Long nvl(Long valor, Long valorDefault) {
        return valor != null ? valor : valorDefault;
    }

    public static int compareMajorMinor(String arg0, String arg1, String modo) {
        Integer intArg0 = Integer.valueOf(arg0.substring(0, arg0.indexOf(46)));
        Integer decArg0 = Integer.valueOf(arg0.substring(arg0.indexOf(46) + 1));
        Integer intArg1 = Integer.valueOf(arg1.substring(0, arg1.indexOf(46)));
        Integer decArg1 = Integer.valueOf(arg1.substring(arg1.indexOf(46) + 1));
        if (modo.equals("FULL")) {
            int comparedIntPart = NumberUtil.compareMajorMinor(arg0, arg1, "INT");
            if (comparedIntPart == 0) {
                return decArg0.compareTo(decArg1);
            }
            return comparedIntPart;
        }
        if (modo.equals("INT")) {
            return intArg0.compareTo(intArg1);
        }
        throw new IllegalArgumentException("modo [" + modo + "] no valido");
    }

    public static boolean safeEquals(Long l1, Long l2) {
        if (l1 == null) {
            return l2 == null;
        }
        return l1.equals(l2);
    }

    public static boolean safeIntegerEquals(Integer l1, Integer l2) {
        if (l1 == null) {
            return l2 == null;
        }
        return l1.equals(l2);
    }

    public static Collection<Long> forceLongCollection(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object o : collection) {
            if (o instanceof Long) {
                result.add((Long)o);
                continue;
            }
            if (o instanceof String) {
                result.add(Long.valueOf((String)o));
                continue;
            }
            if (o instanceof Id) {
                result.add(((Id)o).longValue());
                continue;
            }
            throw new ApplicationException("No vino un tipo valido en la collection [" + o + "]");
        }
        return result;
    }

    public static boolean isValidInteger(String number) {
        if (StringUtil.isEmptyNull(number)) {
            return false;
        }
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Integer getValidInteger(String number) {
        if (StringUtil.isEmptyNull(number)) {
            return null;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isValidDouble(String number) {
        if (StringUtil.isEmptyNull(number)) {
            return false;
        }
        try {
            Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidLong(String number) {
        if (StringUtil.isEmptyNull(number)) {
            return false;
        }
        try {
            Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Long getValidLong(String number) {
        if (StringUtil.isEmptyNull(number)) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean emptySafeEquals(Integer i1, Integer i2) {
        if (i1 == null) {
            return i2 == null;
        }
        return i1.equals(i2);
    }

    public static BigDecimal stringToBigDecimal(String number, Locale locale) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        Number numberFormatted = numberFormat.parse(number);
        return NumberUtil.newBigDecimal(numberFormatted.toString(), 2);
    }

    public static double stringToDouble(String number) throws ParseException {
        return NumberUtil.stringToDouble(number, Locale.ENGLISH);
    }

    public static double stringToDouble(String number, Double defaultValue) throws ParseException {
        return NumberUtil.stringToDouble(number, defaultValue, Locale.ENGLISH);
    }

    public static double stringToDouble(String number, Locale locale) throws ParseException {
        return NumberUtil.stringToDouble(number, null, locale);
    }

    public static double stringToDouble(String number, Double defaultValue, Locale locale) throws ParseException {
        NumberFormat numberFormater = NumberFormat.getNumberInstance(locale);
        if (!StringUtil.isEmptyNull(number)) {
            return numberFormater.parse(number).doubleValue();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return 0.0;
    }

    public static boolean isInListOfIntegers(int item, Integer ... items) {
        return items != null && Arrays.asList(items).contains(item);
    }

    public static boolean isInListOfLongs(long item, Long ... items) {
        return items != null && Arrays.asList(items).contains(item);
    }

    public static boolean isInListOfDoubles(double item, Double ... items) {
        return items != null && Arrays.asList(items).contains(item);
    }

    public static BigDecimal calculatePercetange(double total, double secondNumber) {
        return NumberUtil.toBigDecimal(secondNumber * 100.0 / total);
    }

    public static BigDecimal calculateDiffPercetange(double total, double secondNumber) {
        return NumberUtil.toBigDecimal((total - secondNumber) * 100.0 / total);
    }
}

