/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class PasswordUtil {
    private static PasswordUtil instance;

    public static synchronized PasswordUtil getInstance() {
        if (instance == null) {
            instance = new PasswordUtil();
        }
        return instance;
    }

    private PasswordUtil() {
    }

    public synchronized String hashPassword(String password) throws ApplicationException {
        MessageDigest messageDigest = null;
        if (password == null) {
            return null;
        }
        if (password.length() > 100) {
            password = password.substring(0, 100);
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ApplicationException("Error de encripcion: " + ex.getMessage());
        }
        messageDigest.update(password.getBytes(StandardCharsets.UTF_8));
        byte[] raw = messageDigest.digest();
        return DatatypeConverter.printBase64Binary((byte[])raw);
    }
}

