/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class CriteriaBuilder
implements Serializable {
    static Logger log = LogManager.getLogger(CriteriaBuilder.class);

    public static Criterion createForLikeInList(String field, Collection<String> expresion) {
        if (CollectionUtils.isEmpty(expresion)) {
            return null;
        }
        ArrayList<Object> orExpressions = new ArrayList<Object>();
        for (String tag : expresion) {
            tag = tag.trim();
            MatchMode matchMode = MatchMode.ANYWHERE;
            boolean anyLike = false;
            if (tag.charAt(0) == '%') {
                tag = tag.substring(1);
                matchMode = MatchMode.END;
                anyLike = true;
            }
            if (tag.endsWith("%")) {
                tag = tag.substring(0, tag.length() - 1);
                matchMode = matchMode.equals((Object)MatchMode.END) ? MatchMode.ANYWHERE : MatchMode.START;
                anyLike = true;
            }
            if (anyLike) {
                orExpressions.add(Restrictions.ilike((String)field, (String)tag, (MatchMode)matchMode));
                continue;
            }
            orExpressions.add(Restrictions.eq((String)field, (Object)tag));
        }
        if (orExpressions.size() == 1) {
            return (Criterion)orExpressions.get(0);
        }
        if (orExpressions.size() > 1) {
            return Restrictions.or((Criterion[])orExpressions.toArray(new Criterion[0]));
        }
        return null;
    }
}

