/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.file;

import ar.com.sdd.commons.util.file.FilterCondition;
import ar.com.sdd.commons.util.file.FilterOptionCondition;
import ar.com.sdd.commons.util.file.FilterRejectCondition;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameFilter
implements FilenameFilter {
    private Collection conditions;

    public FileNameFilter(Collection conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean acceptFile = true;
        int options = 0;
        int optionsAccepted = 0;
        if (this.conditions != null) {
            Iterator itConditions = this.conditions.iterator();
            while (itConditions.hasNext() && acceptFile) {
                FilterCondition condition = (FilterCondition)itConditions.next();
                int matchType = condition.getMatchType();
                String filterString = condition.getFilterString();
                String nameToMatch = name;
                if (condition.getIgnoreCase()) {
                    nameToMatch = nameToMatch.toUpperCase();
                    filterString = filterString.toUpperCase();
                }
                if (matchType == 0) {
                    acceptFile = nameToMatch.startsWith(filterString);
                } else if (matchType == 1) {
                    acceptFile = nameToMatch.endsWith(filterString);
                } else if (matchType == 2) {
                    String charInPto = "\\.";
                    String charOutPtoRE = "\\[\\.\\]";
                    String charInAster = "\\*";
                    String charOutPtoAster = "\\.\\*";
                    String charsProhibidos = "(\\.\\.)/";
                    filterString = filterString.replaceAll(charInPto, charOutPtoRE);
                    filterString = filterString.replaceAll(charInAster, charOutPtoAster);
                    filterString = filterString.replaceAll(charsProhibidos, charOutPtoAster);
                    String charInPreg = "\\?";
                    String charOutPto = "\\.\\?";
                    filterString = filterString.replaceAll(charInPreg, charOutPto);
                    Pattern Patron = Pattern.compile(filterString);
                    Matcher M = Patron.matcher(nameToMatch);
                    acceptFile = M.matches();
                } else if (matchType == 3) {
                    Pattern Patron = Pattern.compile(filterString);
                    Matcher M = Patron.matcher(nameToMatch);
                    acceptFile = M.matches();
                }
                if (condition instanceof FilterRejectCondition) {
                    acceptFile = !acceptFile;
                    continue;
                }
                if (!(condition instanceof FilterOptionCondition)) continue;
                ++options;
                if (acceptFile) {
                    ++optionsAccepted;
                }
                acceptFile = true;
            }
        }
        if (options > 0 && optionsAccepted == 0) {
            acceptFile = false;
        }
        return acceptFile;
    }
}

