/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.lineparser;

import ar.com.sdd.commons.util.lineparser.LineParser;
import ar.com.sdd.commons.util.lineparser.LineParserException;
import java.util.StringTokenizer;

public class CSVLineParser
extends LineParser {
    protected String separators = ",";

    public CSVLineParser(String[] fieldNames) {
        super(fieldNames);
    }

    public String getSeparators() {
        return this.separators;
    }

    public void setSeparators(String separators) {
        this.separators = separators.replaceAll("TAB", "\t");
    }

    @Override
    public void parse(String lineBuffer) throws LineParserException {
        if (lineBuffer == null) {
            this.resetFieldValues();
            return;
        }
        StringTokenizer strTokenizer = new StringTokenizer(lineBuffer, this.separators, true);
        String fieldValue = null;
        int i = 0;
        while (strTokenizer.hasMoreTokens()) {
            String token = strTokenizer.nextToken();
            if (i >= this.getNumOfFields()) continue;
            if (this.separators.indexOf(token) != -1) {
                this.fieldValues[i] = fieldValue;
                ++i;
                fieldValue = null;
                continue;
            }
            fieldValue = token.trim();
            if (strTokenizer.hasMoreTokens()) continue;
            this.fieldValues[i] = fieldValue;
        }
        while (i < this.getNumOfFields()) {
            this.fieldValues[i++] = fieldValue;
            fieldValue = null;
        }
    }
}

