/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.mapper.ValueMapper;
import java.util.HashMap;
import java.util.Map;

public class DecodeMapper
extends ValueMapper {
    private final Map<String, String> pairs = new HashMap<String, String>();
    public static final String ESCAPE_PIPE = "_ESCPIPE_";
    public static final String ESCAPE_SEMICOLON = "_ESCPYC_";
    public static final String ESCAPE_ENTER = "_ESCPENTER_";

    public DecodeMapper(String decode) {
        String[] maps;
        for (String map : maps = StringUtil.split(decode, ';')) {
            this.addMap(map.replace(ESCAPE_SEMICOLON, ";").replace(ESCAPE_ENTER, "\\n"));
        }
    }

    public DecodeMapper() {
    }

    public DecodeMapper addMap(String map) {
        String[] token = StringUtil.split(map, '|');
        if (token.length > 1) {
            this.pairs.put(token[0].replace(ESCAPE_PIPE, "|"), token[1].replace(ESCAPE_PIPE, "|"));
        } else {
            this.pairs.put("default", token[0].replace(ESCAPE_PIPE, "|"));
        }
        return this;
    }

    @Override
    public String map(String source) {
        if (this.pairs.containsKey(source)) {
            return this.pairs.get(source);
        }
        String defaultValue = this.pairs.get("default");
        if ("$ECHO".equals(defaultValue)) {
            return source;
        }
        return defaultValue;
    }

    public static String map(String decode, String source) {
        DecodeMapper map = new DecodeMapper(decode);
        return map.map(source);
    }
}

