/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.mapper.ValueMapper;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroovyMapper
extends ValueMapper {
    private static Logger log = LogManager.getLogger(GroovyMapper.class);
    private Map<String, String> variables = new HashMap<String, String>();
    private String expression = "";
    private Script compiledScript = null;

    public GroovyMapper(String decode) {
        try {
            String[] tokens = decode.split(";");
            if (tokens.length > 0) {
                for (String token : tokens) {
                    String name = token.substring(0, token.indexOf(61));
                    String value = token.substring(name.length() + 1);
                    if (name.startsWith("exp")) {
                        this.expression = value;
                        continue;
                    }
                    this.variables.put(name, value);
                }
                if (this.expression != null && !this.expression.equals("")) {
                    GroovyShell groovyShell = new GroovyShell();
                    this.compiledScript = groovyShell.parse(this.expression);
                }
            }
        }
        catch (Exception e) {
            log.error("Error interpretando el decode:" + decode, (Throwable)e);
        }
    }

    @Override
    public String map(String source) {
        if (this.compiledScript != null) {
            Binding binding = new Binding();
            block6: for (String variable : this.variables.keySet()) {
                Object value = StringUtil.fromToParser(source, this.variables.get(variable));
                switch (variable.charAt(0)) {
                    case 's': {
                        binding.setVariable(variable, value);
                        continue block6;
                    }
                    case 'd': {
                        if (((String)value).indexOf(45) > 0 && ((String)value).charAt(0) != '-') {
                            value = ((String)value).trim();
                            value = "-" + ((String)value).substring(0, ((String)value).length() - 1).trim();
                        }
                        binding.setVariable(variable, (Object)Double.parseDouble(StringUtil.nonEmpty((String)value, "0")));
                        continue block6;
                    }
                    case 'l': {
                        binding.setVariable(variable, (Object)Long.parseLong(StringUtil.nonEmpty((String)value, "0")));
                        continue block6;
                    }
                    case 'i': {
                        binding.setVariable(variable, (Object)Integer.parseInt(StringUtil.nonEmpty((String)value, "0")));
                        continue block6;
                    }
                }
                log.error("Indicador de tipo invalido [" + variable.charAt(0) + "] para " + variable + "/" + (String)value);
            }
            this.compiledScript.setBinding(binding);
            Object result = this.compiledScript.run();
            return String.valueOf(result);
        }
        return null;
    }
}

