/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.mapper.ValueMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplaceMapper
extends ValueMapper {
    private LinkedHashMap<Pattern, String> replacePairs = new LinkedHashMap();
    private boolean replaceFirstMatching = false;
    public static final String ESCAPE_PIPE = "_ESCPIPE_";
    public static final String ESCAPE_SEMICOLON = "_ESCPYC_";
    public static final String ECHO = "=^(.*)$|$1";

    public ReplaceMapper(String replaceSpec) {
        this.replaceFirstMatching = replaceSpec.startsWith("=");
        if (this.replaceFirstMatching) {
            replaceSpec = replaceSpec.substring(1);
        }
        String[] specs = replaceSpec.split(";");
        for (int i = 0; i < specs.length; ++i) {
            specs[i] = specs[i].replace(ESCAPE_SEMICOLON, ";");
            String[] spec = specs[i].split("[|]");
            spec[0] = spec[0].replace(ESCAPE_PIPE, "|");
            if (spec.length == 1) {
                this.replacePairs.put(Pattern.compile(spec[0]), null);
                continue;
            }
            spec[1] = spec[1].replace(ESCAPE_PIPE, "|");
            this.replacePairs.put(Pattern.compile(spec[0]), spec[1]);
        }
    }

    @Override
    public String map(String source) {
        if (source == null) {
            return null;
        }
        boolean didReplacement = false;
        for (Map.Entry<Pattern, String> spec : this.replacePairs.entrySet()) {
            Matcher matcher = spec.getKey().matcher(source);
            try {
                String replacement = spec.getValue();
                if (replacement == null) {
                    replacement = "";
                }
                String oldSource = source;
                source = matcher.replaceAll(replacement);
                if (!source.equals(oldSource)) {
                    didReplacement = true;
                } else {
                    matcher.reset();
                    if (matcher.find()) {
                        didReplacement = true;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!didReplacement || !this.replaceFirstMatching) continue;
            break;
        }
        return !this.replaceFirstMatching || didReplacement ? source : null;
    }

    public static String map(String decode, String source) {
        ReplaceMapper map = new ReplaceMapper(decode);
        return map.map(source);
    }
}

