/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigComplex {
    BigDecimal re;
    BigDecimal im;
    static final BigComplex ZERO = new BigComplex(BigDecimal.ZERO, BigDecimal.ZERO);

    public BigComplex() {
        this.re = BigDecimal.ZERO;
        this.im = BigDecimal.ZERO;
    }

    public BigComplex(BigDecimal x, BigDecimal y) {
        this.re = x;
        this.im = y;
    }

    public BigComplex(BigDecimal x) {
        this.re = x;
        this.im = BigDecimal.ZERO;
    }

    public BigComplex(double x, double y) {
        this.re = new BigDecimal(x);
        this.im = new BigDecimal(y);
    }

    BigComplex multiply(BigComplex oth, MathContext mc) {
        BigDecimal a = this.re.add(this.im).multiply(oth.re);
        BigDecimal b = oth.re.add(oth.im).multiply(this.im);
        BigDecimal c = oth.im.subtract(oth.re).multiply(this.re);
        BigDecimal x = a.subtract(b, mc);
        BigDecimal y = a.add(c, mc);
        return new BigComplex(x, y);
    }

    BigComplex add(BigDecimal oth) {
        BigDecimal x = this.re.add(oth);
        return new BigComplex(x, this.im);
    }

    BigComplex subtract(BigComplex oth) {
        BigDecimal x = this.re.subtract(oth.re);
        BigDecimal y = this.im.subtract(oth.im);
        return new BigComplex(x, y);
    }

    BigComplex conj() {
        return new BigComplex(this.re, this.im.negate());
    }

    BigDecimal norm() {
        return this.re.multiply(this.re).add(this.im.multiply(this.im));
    }

    BigDecimal abs(MathContext mc) {
        return BigDecimalMath.sqrt(this.norm(), mc);
    }

    BigComplex sqrt(MathContext mc) {
        BigDecimal half = new BigDecimal("2");
        BigDecimal l = this.abs(mc);
        if (l.compareTo(BigDecimal.ZERO) == 0) {
            return new BigComplex(BigDecimalMath.scalePrec(BigDecimal.ZERO, mc), BigDecimalMath.scalePrec(BigDecimal.ZERO, mc));
        }
        BigDecimal u = BigDecimalMath.sqrt(l.add(this.re).divide(half, mc), mc);
        BigDecimal v = BigDecimalMath.sqrt(l.subtract(this.re).divide(half, mc), mc);
        if (this.im.compareTo(BigDecimal.ZERO) >= 0) {
            return new BigComplex(u, v);
        }
        return new BigComplex(u, v.negate());
    }

    BigComplex inverse(MathContext mc) {
        BigDecimal hyp = this.norm();
        return new BigComplex(this.re.divide(hyp, mc), this.im.divide(hyp, mc).negate());
    }

    BigComplex divide(BigComplex oth, MathContext mc) {
        return this.multiply(oth.inverse(mc), mc);
    }

    public String toString() {
        return "(" + this.re.toString() + "," + this.im.toString() + ")";
    }

    public String toString(MathContext mc) {
        return "(" + this.re.round(mc).toString() + "," + this.im.round(mc).toString() + ")";
    }
}

