/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigDecimalMath;
import ar.com.sdd.commons.util.math.BigIntegerMath;
import ar.com.sdd.commons.util.math.BigSurdVec;
import ar.com.sdd.commons.util.math.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.security.ProviderException;

public class BigSurd
implements Cloneable,
Comparable<BigSurd> {
    public static BigSurd ZERO = new BigSurd();
    public static BigSurd ONE = new BigSurd(Rational.ONE, Rational.ONE);
    Rational pref;
    Rational disc;

    public BigSurd() {
        this.pref = Rational.ZERO;
        this.disc = Rational.ZERO;
    }

    public BigSurd(Rational a, Rational b) {
        this.pref = a;
        if (b.signum() < 0) {
            throw new ProviderException("Not implemented: imaginary surds");
        }
        this.disc = b;
        this.normalize();
        this.normalizeG();
    }

    public BigSurd(int a, int b) {
        this(Rational.ONE, new Rational(a, b));
    }

    public BigSurd(BigInteger a) {
        this(Rational.ONE, new Rational(a, BigInteger.ONE));
    }

    public BigSurd clone() {
        Rational fclon = this.pref.clone();
        Rational dclon = this.disc.clone();
        BigSurd cl = new BigSurd();
        cl.pref = fclon;
        cl.disc = dclon;
        return cl;
    }

    public BigSurdVec add(BigSurd val) {
        if (this.signum() == 0) {
            return new BigSurdVec(val);
        }
        if (val.signum() == 0) {
            return new BigSurdVec(this);
        }
        return new BigSurdVec(this, val);
    }

    public BigSurd multiply(BigSurd val) {
        return new BigSurd(this.pref.multiply(val.pref), this.disc.multiply(val.disc));
    }

    public BigSurd multiply(Rational val) {
        return new BigSurd(this.pref.multiply(val), this.disc);
    }

    public BigSurd multiply(BigInteger val) {
        return new BigSurd(this.pref.multiply(val), this.disc);
    }

    public BigSurd multiply(int val) {
        BigInteger tmp = new BigInteger("" + val);
        return this.multiply(tmp);
    }

    public Rational sqr() {
        Rational res = this.pref.pow(2);
        res = res.multiply(this.disc);
        return res;
    }

    public BigSurd divide(BigSurd val) {
        if (val.signum() == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        return new BigSurd(this.pref.divide(val.pref), this.disc.divide(val.disc));
    }

    public BigSurd divide(BigInteger val) {
        if (val.signum() == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        return new BigSurd(this.pref.divide(val), this.disc);
    }

    public BigSurd divide(int val) {
        if (val == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        return new BigSurd(this.pref.divide(val), this.disc);
    }

    public BigSurd negate() {
        BigSurd n = this.clone();
        n.pref = n.pref.negate();
        return n;
    }

    public BigSurd abs() {
        return new BigSurd(this.pref.abs(), this.disc);
    }

    @Override
    public int compareTo(BigSurd val) {
        Rational val2;
        int sig = this.signum();
        int sigv = val.signum();
        if (sig < 0 && sigv >= 0) {
            return -1;
        }
        if (sig > 0 && sigv <= 0) {
            return 1;
        }
        if (sig == 0 && sigv == 0) {
            return 0;
        }
        if (sig == 0 && sigv > 0) {
            return -1;
        }
        if (sig == 0 && sigv < 0) {
            return 1;
        }
        Rational this2 = this.sqr();
        int c = this2.compareTo(val2 = val.sqr());
        if (c == 0) {
            return 0;
        }
        if (sig > 0 && c > 0 || sig < 0 && c < 0) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        if (this.disc.compareTo(Rational.ONE) != 0 && this.disc.compareTo(Rational.ZERO) != 0) {
            return "(" + this.pref.toString() + ")*(" + this.disc.toString() + ")^(1/2)";
        }
        return this.pref.toString();
    }

    public double doubleValue() {
        Rational p2 = this.pref.pow(2).multiply(this.disc);
        double res = p2.doubleValue();
        return this.pref.signum() >= 0 ? Math.sqrt(res) : -Math.sqrt(res);
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean isBigInteger() {
        return this.pref.isBigInteger() && (this.disc.signum() == 0 || this.disc.compareTo(Rational.ONE) == 0);
    }

    public boolean isRational() {
        return this.disc.signum() == 0 || this.disc.compareTo(Rational.ONE) == 0;
    }

    public Rational toRational() {
        if (this.isRational()) {
            return this.pref;
        }
        throw new ArithmeticException("Undefined conversion " + this.toString() + " to Rational.");
    }

    public int signum() {
        return this.pref.signum();
    }

    protected void normalize() {
        if (this.disc.signum() != 0) {
            BigInteger numC = BigIntegerMath.core(this.disc.numer());
            BigInteger sq = this.disc.numer().divide(numC);
            BigInteger sqf = BigIntegerMath.isqrt(sq);
            this.pref = this.pref.multiply(sqf);
            BigInteger denC = BigIntegerMath.core(this.disc.denom());
            sq = this.disc.denom().divide(denC);
            sqf = BigIntegerMath.isqrt(sq);
            this.pref = this.pref.divide(sqf);
            this.disc = new Rational(numC, denC);
        } else {
            this.pref = Rational.ZERO;
        }
    }

    protected void normalizeG() {
        BigInteger d = this.pref.numer().abs().gcd(this.disc.denom());
        if (d.compareTo(BigInteger.ONE) > 0) {
            this.pref = this.pref.divide(d);
            this.disc = this.disc.multiply(d);
            this.disc = this.disc.multiply(d);
        }
        if ((d = this.pref.denom().gcd(this.disc.numer())).compareTo(BigInteger.ONE) > 0) {
            this.pref = this.pref.multiply(d);
            this.disc = this.disc.divide(d);
            this.disc = this.disc.divide(d);
        }
    }

    public BigDecimal BigDecimalValue(MathContext mc) {
        MathContext locmc = new MathContext(mc.getPrecision() + 3, mc.getRoundingMode());
        BigDecimal sqrdis = BigDecimalMath.sqrt(this.disc.BigDecimalValue(locmc), locmc);
        BigDecimal res = sqrdis.multiply(this.pref.BigDecimalValue(mc));
        return BigDecimalMath.scalePrec(res, mc);
    }
}

