/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.Prime;
import ar.com.sdd.commons.util.math.Rational;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Vector;

public class Ifactor
implements Cloneable,
Comparable<Ifactor> {
    public BigInteger n;
    public Vector<Integer> primeexp;
    public static final Ifactor ONE = new Ifactor(1);
    public static final Ifactor ZERO = new Ifactor(0);

    public Ifactor(int number) {
        this.n = new BigInteger("" + number);
        this.primeexp = new Vector();
        if (number > 1) {
            int primindx = 0;
            Prime primes = new Prime();
            while (number > 1) {
                int ex = 0;
                int p = primes.at(primindx).intValue();
                while (number % p == 0) {
                    ++ex;
                    if ((number /= p) != 1) continue;
                }
                if (ex > 0) {
                    this.primeexp.add(new Integer(p));
                    this.primeexp.add(new Integer(ex));
                }
                ++primindx;
            }
        } else if (number == 1) {
            this.primeexp.add(new Integer(1));
            this.primeexp.add(new Integer(0));
        }
    }

    public Ifactor(BigInteger number) {
        this.n = number;
        this.primeexp = new Vector();
        if (number.compareTo(BigInteger.ONE) == 0) {
            this.primeexp.add(new Integer(1));
            this.primeexp.add(new Integer(0));
        } else {
            int primindx = 0;
            Prime primes = new Prime();
            while (number.compareTo(BigInteger.ONE) == 1) {
                int ex = 0;
                BigInteger p = primes.at(primindx);
                while (number.remainder(p).compareTo(BigInteger.ZERO) == 0) {
                    ++ex;
                    if ((number = number.divide(p)).compareTo(BigInteger.ONE) != 0) continue;
                }
                if (ex > 0) {
                    this.primeexp.add(new Integer(p.intValue()));
                    this.primeexp.add(new Integer(ex));
                }
                ++primindx;
            }
        }
    }

    public Ifactor(Vector<Integer> pows) {
        this.primeexp = new Vector(2 * pows.size());
        if (pows.size() > 0) {
            this.n = BigInteger.ONE;
            Prime primes = new Prime();
            for (int primindx = 0; primindx < pows.size(); ++primindx) {
                int ex = pows.elementAt(primindx);
                BigInteger p = primes.at(primindx);
                this.n = this.n.multiply(p.pow(ex));
                this.primeexp.add(new Integer(p.intValue()));
                this.primeexp.add(new Integer(ex));
            }
        } else {
            this.n = BigInteger.ZERO;
        }
    }

    public Ifactor(Ifactor oth) {
        this.n = oth.n;
        this.primeexp = oth.primeexp;
    }

    public Ifactor clone() {
        Vector p = (Vector)this.primeexp.clone();
        Ifactor cl = new Ifactor(0);
        cl.n = new BigInteger("" + this.n);
        return cl;
    }

    public boolean equals(Ifactor oth) {
        return this.n.compareTo(oth.n) == 0;
    }

    public Ifactor multiply(BigInteger oth) {
        return this.multiply(new Ifactor(oth));
    }

    public Ifactor multiply(int oth) {
        return this.multiply(new Ifactor(oth));
    }

    public Ifactor multiply(Ifactor oth) {
        return this.multGcdLcm(oth, 0);
    }

    public Ifactor lcm(Ifactor oth) {
        return this.multGcdLcm(oth, 2);
    }

    public Ifactor gcd(Ifactor oth) {
        return this.multGcdLcm(oth, 1);
    }

    protected Ifactor multGcdLcm(Ifactor oth, int type) {
        Ifactor prod = new Ifactor(0);
        if (this.primeexp.size() != 0 && oth.primeexp.size() != 0) {
            if (this.primeexp.firstElement() == 1 && type == 0) {
                return oth;
            }
            if (this.primeexp.firstElement() == 1 && type == 2) {
                return oth;
            }
            if (this.primeexp.firstElement() == 1 && type == 1) {
                return this;
            }
            if (oth.primeexp.firstElement() == 1 && type == 0) {
                return this;
            }
            if (oth.primeexp.firstElement() == 1 && type == 2) {
                return this;
            }
            if (oth.primeexp.firstElement() == 1 && type == 1) {
                return oth;
            }
            int idxThis = 0;
            int idxOth = 0;
            switch (type) {
                case 0: {
                    prod.n = this.n.multiply(oth.n);
                    break;
                }
                case 1: {
                    prod.n = this.n.gcd(oth.n);
                    break;
                }
                case 2: {
                    prod.n = this.n.multiply(oth.n).divide(this.n.gcd(oth.n));
                }
            }
            block13: while (idxOth < oth.primeexp.size() || idxThis < this.primeexp.size()) {
                if (idxOth >= oth.primeexp.size()) {
                    if (type == 0 || type == 2) {
                        prod.primeexp.add(this.primeexp.elementAt(idxThis));
                        prod.primeexp.add(this.primeexp.elementAt(idxThis + 1));
                    }
                    idxThis += 2;
                    continue;
                }
                if (idxThis >= this.primeexp.size()) {
                    if (type == 0 || type == 2) {
                        prod.primeexp.add(oth.primeexp.elementAt(idxOth));
                        prod.primeexp.add(oth.primeexp.elementAt(idxOth + 1));
                    }
                    idxOth += 2;
                    continue;
                }
                switch (this.primeexp.elementAt(idxThis).compareTo(oth.primeexp.elementAt(idxOth))) {
                    case 0: {
                        int ex;
                        Integer p = this.primeexp.elementAt(idxThis);
                        switch (type) {
                            case 0: {
                                ex = this.primeexp.elementAt(idxThis + 1) + oth.primeexp.elementAt(idxOth + 1);
                                break;
                            }
                            case 1: {
                                ex = Math.min(this.primeexp.elementAt(idxThis + 1), oth.primeexp.elementAt(idxOth + 1));
                                break;
                            }
                            default: {
                                ex = Math.max(this.primeexp.elementAt(idxThis + 1), oth.primeexp.elementAt(idxOth + 1));
                            }
                        }
                        prod.primeexp.add(p);
                        prod.primeexp.add(new Integer(ex));
                        idxOth += 2;
                        idxThis += 2;
                        continue block13;
                    }
                    case 1: {
                        if (type == 0 || type == 2) {
                            prod.primeexp.add(oth.primeexp.elementAt(idxOth));
                            prod.primeexp.add(oth.primeexp.elementAt(idxOth + 1));
                        }
                        idxOth += 2;
                        continue block13;
                    }
                }
                if (type == 0 || type == 2) {
                    prod.primeexp.add(this.primeexp.elementAt(idxThis));
                    prod.primeexp.add(this.primeexp.elementAt(idxThis + 1));
                }
                idxThis += 2;
            }
        }
        return prod;
    }

    public Ifactor divide(Ifactor oth) {
        return new Ifactor(this.n.divide(oth.n));
    }

    public Ifactor add(BigInteger oth) {
        if (oth.compareTo(BigInteger.ZERO) != 0) {
            return new Ifactor(this.n.add(oth));
        }
        return this;
    }

    public Ifactor pow(int exponent) throws ArithmeticException {
        if (exponent < 0) {
            throw new ArithmeticException("Cannot raise " + this.toString() + " to negative " + exponent);
        }
        if (exponent == 0) {
            return new Ifactor(1);
        }
        if (exponent == 1) {
            return this;
        }
        Ifactor pows = new Ifactor(0);
        for (int i = 0; i < this.primeexp.size(); i += 2) {
            Integer p = this.primeexp.elementAt(i);
            int ex = this.primeexp.elementAt(i + 1);
            pows.primeexp.add(p);
            pows.primeexp.add(new Integer(ex * exponent));
        }
        return pows;
    }

    public Rational root(int r) throws ArithmeticException {
        if (r == 0) {
            throw new ArithmeticException("Cannot pull zeroth root of " + this.toString());
        }
        if (r < 0) {
            Rational invRoot = this.root(-r);
            return Rational.ONE.divide(invRoot);
        }
        BigInteger pows = BigInteger.ONE;
        for (int i = 0; i < this.primeexp.size(); i += 2) {
            int ex = this.primeexp.elementAt(i + 1);
            if (ex % r != 0) {
                throw new ArithmeticException("Cannot pull " + r + "th root of " + this.toString());
            }
            pows.multiply(new BigInteger("" + this.primeexp.elementAt(i)).pow(ex / r));
        }
        return new Rational(pows);
    }

    public Vector<BigInteger> divisors() {
        Vector<BigInteger> d = new Vector<BigInteger>();
        if (this.n.compareTo(BigInteger.ZERO) == 0) {
            return d;
        }
        d.add(BigInteger.ONE);
        if (this.n.compareTo(BigInteger.ONE) > 0) {
            Ifactor dp = this.dropPrime();
            int ez = this.primeexp.lastElement();
            Vector<BigInteger> partd = dp.divisors();
            BigInteger pz = new BigInteger(this.primeexp.elementAt(this.primeexp.size() - 2).toString());
            for (int i = 1; i < partd.size(); ++i) {
                d.add(partd.elementAt(i));
            }
            for (int e = 1; e <= ez; ++e) {
                BigInteger pzez = pz.pow(e);
                for (int i = 0; i < partd.size(); ++i) {
                    d.add(partd.elementAt(i).multiply(pzez));
                }
            }
        }
        Collections.sort(d);
        return d;
    }

    public Ifactor sigma() {
        return this.sigma(1);
    }

    public Ifactor sigma(int k) {
        if (this.n.compareTo(BigInteger.ONE) == 0) {
            return ONE;
        }
        if (this.n.compareTo(BigInteger.ZERO) == 0) {
            return ZERO;
        }
        Ifactor resul = ONE;
        for (int i = 0; i < this.primeexp.size(); i += 2) {
            int ex = this.primeexp.elementAt(i + 1);
            if (k == 0) {
                resul = resul.multiply(ex + 1);
                continue;
            }
            Integer p = this.primeexp.elementAt(i);
            BigInteger num = new BigInteger(p.toString()).pow(k * (ex + 1)).subtract(BigInteger.ONE);
            BigInteger deno = new BigInteger(p.toString()).pow(k).subtract(BigInteger.ONE);
            Ifactor f = new Ifactor(num.divide(deno));
            resul = resul.multiply(f);
        }
        return resul;
    }

    public Ifactor dropPrime() {
        if (this.n.compareTo(BigInteger.ONE) <= 0) {
            return this;
        }
        Ifactor pows = new Ifactor(0);
        pows.n = BigInteger.ONE;
        for (int i = 0; i < this.primeexp.size() - 2; i += 2) {
            pows.primeexp.add(this.primeexp.elementAt(i));
            pows.primeexp.add(this.primeexp.elementAt(i + 1));
            BigInteger p = new BigInteger(this.primeexp.elementAt(i).toString());
            int ex = this.primeexp.elementAt(i + 1);
            pows.n = pows.n.multiply(p.pow(ex));
        }
        return pows;
    }

    public boolean issquare() {
        boolean resul = true;
        for (int i = 1; i < this.primeexp.size(); i += 2) {
            if (this.primeexp.elementAt(i) % 2 == 0) continue;
            return false;
        }
        return true;
    }

    public int bigomega() {
        int resul = 0;
        for (int i = 1; i < this.primeexp.size(); i += 2) {
            resul += this.primeexp.elementAt(i).intValue();
        }
        return resul;
    }

    public int omega() {
        return this.primeexp.size() / 2;
    }

    public BigInteger core() {
        BigInteger resul = BigInteger.ONE;
        for (int i = 0; i < this.primeexp.size(); i += 2) {
            if (this.primeexp.elementAt(i + 1) % 2 == 0) continue;
            resul = resul.multiply(new BigInteger(this.primeexp.elementAt(i).toString()));
        }
        return resul;
    }

    public int moebius() {
        if (this.n.compareTo(BigInteger.ONE) <= 0) {
            return 1;
        }
        int k = 1;
        for (int i = 0; i < this.primeexp.size(); i += 2) {
            int e = this.primeexp.elementAt(i + 1);
            if (e > 1) {
                return 0;
            }
            if (e != 1) continue;
            k *= -1;
        }
        return k;
    }

    public Ifactor max(Ifactor oth) {
        if (this.n.compareTo(oth.n) >= 0) {
            return this;
        }
        return oth;
    }

    public Ifactor min(Ifactor oth) {
        if (this.n.compareTo(oth.n) <= 0) {
            return this;
        }
        return oth;
    }

    public static Ifactor max(Vector<Ifactor> set) {
        Ifactor resul = set.elementAt(0);
        for (int i = 1; i < set.size(); ++i) {
            resul = resul.max(set.elementAt(i));
        }
        return resul;
    }

    public static Ifactor min(Vector<Ifactor> set) {
        Ifactor resul = set.elementAt(0);
        for (int i = 1; i < set.size(); ++i) {
            resul = resul.min(set.elementAt(i));
        }
        return resul;
    }

    @Override
    public int compareTo(Ifactor oth) {
        return this.n.compareTo(oth.n);
    }

    public String toString() {
        Object resul = new String(this.n.toString() + ":");
        if (this.n.compareTo(BigInteger.ONE) == 0) {
            resul = (String)resul + "1";
        } else {
            boolean firstMul = true;
            for (int i = 0; i < this.primeexp.size(); i += 2) {
                if (!firstMul) {
                    resul = (String)resul + "*";
                }
                resul = this.primeexp.elementAt(i + 1) > 1 ? (String)resul + this.primeexp.elementAt(i).toString() + "^" + this.primeexp.elementAt(i + 1).toString() : (String)resul + this.primeexp.elementAt(i).toString();
                firstMul = false;
            }
        }
        return resul;
    }

    public static void main(String[] args) {
        BigInteger n = new BigInteger(args[0]);
        System.out.println(new Ifactor(n));
    }
}

