/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.Permute;
import java.util.Random;
import java.util.Vector;

class Permutation
implements Cloneable {
    int[] images;
    private int ord;
    public static int REPOFFSET = 0;

    Permutation(int[] v) {
        this.init(v);
    }

    Permutation(int n) {
        int[] v = new int[n];
        for (int i = 0; i < n; ++i) {
            v[i] = i + REPOFFSET;
        }
        this.init(v);
    }

    Permutation(Vector<Integer> v) {
        int[] varr = new int[v.size()];
        for (int i = 0; i < varr.length; ++i) {
            varr[i] = v.elementAt(i);
        }
        this.init(varr);
    }

    Permutation(int[] parts, int n) {
        this.images = new int[n];
        int el = 0;
        for (int p = 0; p < parts.length; ++p) {
            int plen = parts[p];
            for (int l = 0; l < plen; ++l) {
                this.images[el] = l == plen - 1 ? el + 1 + REPOFFSET - plen : el + 1 + REPOFFSET;
                ++el;
            }
        }
        this.ord = -1;
    }

    Permutation(int[][] cycs) {
        int c;
        int n = 0;
        for (c = 0; c < cycs.length; ++c) {
            n += cycs[c].length;
        }
        this.images = new int[n];
        for (c = 0; c < cycs.length; ++c) {
            int cl = cycs[c].length;
            for (int i = 0; i < cl; ++i) {
                int targ;
                int e = cycs[c][i];
                this.images[e - Permutation.REPOFFSET] = targ = cycs[c][(i + 1) % cl];
            }
        }
        this.ord = Permutation.orderByCycles(cycs);
    }

    private void init(int[] v) {
        this.images = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.images[i] = v[i];
        }
        this.ord = -1;
    }

    public int length() {
        return this.images.length;
    }

    public Permutation clone() {
        return new Permutation(this.images);
    }

    public Permutation inverse() {
        int[] invi = new int[this.images.length];
        for (int i = 0; i < this.images.length; ++i) {
            invi[this.images[i] - Permutation.REPOFFSET] = i + REPOFFSET;
        }
        return new Permutation(invi);
    }

    Permutation multiply(Permutation right) {
        if (this.images.length != right.images.length) {
            throw new IllegalArgumentException("Different permutation lengths " + this.images.length + " vs " + right.images.length);
        }
        int[] prod = new int[this.images.length];
        for (int i = 0; i < this.images.length; ++i) {
            prod[i] = right.images[this.images[i] - REPOFFSET];
        }
        return new Permutation(prod);
    }

    public boolean isUnit() {
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == i + REPOFFSET) continue;
            return false;
        }
        return true;
    }

    static int gcd(int a, int b) {
        while (b > 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    static int lcm(int a, int b) {
        return a / Permutation.gcd(a, b) * b;
    }

    int orderByCycles() {
        if (this.ord <= 0) {
            int[][] cyc = this.cycles();
            if (cyc.length < 1) {
                this.ord = 1;
            } else {
                this.ord = cyc[0].length;
                for (int c = 1; c < cyc.length; ++c) {
                    this.ord = Permutation.lcm(this.ord, cyc[c].length);
                }
            }
        }
        return this.ord;
    }

    static int orderByCycles(int[][] cyc) {
        if (cyc.length < 1) {
            return 1;
        }
        int ord = cyc[0].length;
        for (int c = 1; c < cyc.length; ++c) {
            ord = Permutation.lcm(ord, cyc[c].length);
        }
        return ord;
    }

    /*
     * Unable to fully structure code
     */
    public int[][] cycles() {
        c = new Vector<int[]>();
        done = new boolean[this.images.length];
        while (true) {
            for (notmoved = 0; notmoved < this.images.length && done[notmoved]; ++notmoved) {
            }
            if (notmoved == this.images.length) break;
            tracei = this.orbit(notmoved + Permutation.REPOFFSET);
            done[notmoved] = true;
            for (i = 1; i < tracei.length; ++i) {
                done[tracei[i] - Permutation.REPOFFSET] = true;
            }
            if (tracei.length <= 1) ** continue;
            c.add(tracei);
        }
        cycs = new int[c.size()][];
        for (i = 0; i < c.size(); ++i) {
            cycs[i] = (int[])c.elementAt(i);
        }
        return cycs;
    }

    public String cyclRep() {
        int[][] allcyc = this.cycles();
        Object rep = new String();
        if (allcyc.length == 0) {
            return new String("()");
        }
        for (int c = 0; c < allcyc.length; ++c) {
            for (int e = 0; e < allcyc[c].length; ++e) {
                rep = e == 0 ? (String)rep + "(" + (allcyc[c][e] + 1 - REPOFFSET) : (e == allcyc[c].length - 1 ? (String)rep + " " + (allcyc[c][e] + 1 - REPOFFSET) + ")" : (String)rep + " " + (allcyc[c][e] + 1 - REPOFFSET));
            }
        }
        return rep;
    }

    int imageOf(int e) {
        if (e < REPOFFSET) {
            throw new IllegalArgumentException("Argument " + e + " out of range for length " + this.images.length);
        }
        if (e >= this.images.length + REPOFFSET) {
            return e;
        }
        return this.images[e - REPOFFSET];
    }

    int[] orbit(int s) {
        int[] oArr;
        if (s < REPOFFSET || s >= this.images.length + REPOFFSET) {
            throw new IllegalArgumentException("Argument " + s + " out of range ");
        }
        Vector<Integer> or = new Vector<Integer>();
        or.add(new Integer(s));
        int i = s;
        while ((i = this.imageOf(i)) != s) {
            or.add(new Integer(i));
        }
        if (or.size() >= 2) {
            oArr = new int[or.size()];
            for (int j = 0; j < or.size(); ++j) {
                oArr[j] = (Integer)or.elementAt(j);
            }
        } else {
            oArr = new int[]{};
        }
        return oArr;
    }

    public void swap(int i, int j) {
        int tmp = this.images[i];
        this.images[i] = this.images[j];
        this.images[j] = tmp;
    }

    public int compareTo(Permutation oth) {
        if (this.images.length < oth.images.length) {
            return -1;
        }
        if (this.images.length > oth.images.length) {
            return 1;
        }
        for (int j = 0; j < this.images.length; ++j) {
            if (this.images[j] < oth.images[j]) {
                return -1;
            }
            if (this.images[j] <= oth.images[j]) continue;
            return 1;
        }
        return 0;
    }

    public int smallestMoved() {
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == i + REPOFFSET) continue;
            return i;
        }
        return this.images.length;
    }

    public int largestFixed() {
        for (int i = this.images.length - 1; i >= 0; --i) {
            if (this.images[i] != i + REPOFFSET) continue;
            return i;
        }
        return -1;
    }

    public static int smallestFixed(Vector<Permutation> pers) {
        int el = REPOFFSET;
        while (true) {
            boolean isfix = true;
            for (Permutation p : pers) {
                if (p.imageOf(el) == el) continue;
                isfix = false;
                break;
            }
            if (isfix) {
                return el;
            }
            ++el;
        }
    }

    public int nrMoved() {
        int m = 0;
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == i + REPOFFSET) continue;
            ++m;
        }
        return m;
    }

    public static int nrMoved(Permutation[] per) {
        int minp = 0;
        int m = 1 + per[0].length();
        for (int p = 0; p < per.length; ++p) {
            Permutation thisp = per[p];
            if (thisp.isUnit()) continue;
            if (thisp.nrMoved() < m) {
                minp = p;
            }
            m = Math.min(m, thisp.nrMoved());
        }
        System.out.println("deg " + m + " at g" + (minp + 1) + " " + per[minp].cyclRep());
        return m;
    }

    boolean isSorted() {
        int f;
        if (this.orderByCycles() == 1) {
            return true;
        }
        int m = this.smallestMoved();
        return m == (f = this.largestFixed()) + 1;
    }

    boolean isCycSorted() {
        int j;
        int i;
        int[][] cyc = this.cycles();
        if (cyc.length <= 1) {
            return true;
        }
        for (i = 0; i < cyc.length - 1; ++i) {
            for (j = i + 1; j < cyc.length; ++j) {
                if (cyc[j].length >= cyc[i].length) continue;
                return false;
            }
        }
        for (i = 0; i < cyc.length - 1; ++i) {
            for (j = i + 1; j < cyc.length; ++j) {
                for (int ei = 0; ei < cyc[i].length; ++ei) {
                    for (int ej = 0; ej < cyc[j].length; ++ej) {
                        if (cyc[j][ej] > cyc[i][ei]) continue;
                        return false;
                    }
                }
            }
        }
        for (i = 0; i < cyc.length - 1; ++i) {
            for (int ei = 0; ei < cyc[i].length - 1; ++ei) {
                if (cyc[i][ei + 1] > cyc[i][ei]) continue;
                return false;
            }
        }
        return true;
    }

    boolean isPivot() {
        return this.isSorted() && this.isCycSorted();
    }

    public String toString() {
        Object s = new String("(");
        for (int i = 0; i < this.images.length; ++i) {
            s = (String)s + (this.images[i] + 1 - REPOFFSET) + " ";
        }
        s = (String)s + ")";
        return s;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            int n = Integer.parseInt(args[0]);
            int[] v = new int[n];
            for (int i = 0; i < n; ++i) {
                v[i] = i + REPOFFSET;
            }
            Permutation p = new Permutation(v);
            Random r = new Random();
            for (int i = 0; i < n; ++i) {
                int rani = r.nextInt(n);
                int ranj = r.nextInt(n);
                p.swap(rani, ranj);
            }
            System.out.println("starting with " + p.toString());
            Permutation sq = p.multiply(p);
            System.out.println("square is " + sq.toString());
            System.out.println("order is " + p.orderByCycles());
            System.out.println("cycles are " + p.cyclRep());
            Permutation invp = p.inverse();
            System.out.println("inverse is " + invp + " product " + invp.multiply(p));
        } else if (args.length == 0) {
            int[] maxc = new int[]{0, 1, 2, 3, 4, 6, 6, 12, 15, 20, 30, 30, 60, 60, 84, 105, 140, 210, 210, 420, 420, 420, 420, 840, 840};
            for (int n = 1; n < 10; ++n) {
                int[] v = new int[n];
                for (int i = 0; i < n; ++i) {
                    v[i] = i + REPOFFSET;
                }
                long cyct = 0L;
                for (int cylen = 1; cylen <= maxc[n]; ++cylen) {
                    long ct = 0L;
                    Permute S = new Permute(v);
                    while (!S.exhst) {
                        int[] p = S.next();
                        Permutation pper = new Permutation(p);
                        if (pper.orderByCycles() != cylen) continue;
                        ++ct;
                    }
                    System.out.print(" " + ct);
                    cyct += ct;
                }
                System.out.println(": " + cyct);
            }
        }
    }
}

