/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigDecimalMath;
import ar.com.sdd.commons.util.math.BigIntegerMath;
import ar.com.sdd.commons.util.math.Factorial;
import ar.com.sdd.commons.util.math.Ifactor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Vector;

public class Rational
implements Cloneable,
Comparable<Rational> {
    BigInteger a;
    BigInteger b;
    public static BigInteger MAX_INT = new BigInteger("2147483647");
    public static BigInteger MIN_INT = new BigInteger("-2147483648");
    public static Rational ZERO = new Rational();
    static Rational ONE = new Rational(1, 1);
    public static Rational HALF = new Rational(1, 2);

    public Rational() {
        this.a = BigInteger.ZERO;
        this.b = BigInteger.ONE;
    }

    public Rational(BigInteger a, BigInteger b) {
        this.a = a;
        this.b = b;
        this.normalize();
    }

    public Rational(BigInteger a) {
        this.a = a;
        this.b = new BigInteger("1");
    }

    public Rational(int a, int b) {
        this(new BigInteger("" + a), new BigInteger("" + b));
    }

    public Rational(int n) {
        this(n, 1);
    }

    public Rational(String str) throws NumberFormatException {
        this(str, 10);
    }

    public Rational(String str, int radix) throws NumberFormatException {
        int hasslah = str.indexOf("/");
        if (hasslah == -1) {
            this.a = new BigInteger(str, radix);
            this.b = new BigInteger("1", radix);
        } else {
            this.a = new BigInteger(str.substring(0, hasslah), radix);
            this.b = new BigInteger(str.substring(hasslah + 1), radix);
            this.normalize();
        }
    }

    public Rational(Vector<BigInteger> cfr) {
        if (cfr.size() == 0) {
            throw new NumberFormatException("Empty continued fraction");
        }
        if (cfr.size() == 1) {
            this.a = cfr.firstElement();
            this.b = BigInteger.ONE;
        } else {
            Vector<BigInteger> clond = new Vector<BigInteger>();
            for (int i = 1; i < cfr.size(); ++i) {
                clond.add(cfr.elementAt(i));
            }
            Rational rec = new Rational(clond);
            this.a = cfr.firstElement().multiply(rec.a).add(rec.b);
            this.b = rec.a;
            this.normalize();
        }
    }

    public Rational clone() {
        BigInteger aclon = new BigInteger("" + this.a);
        BigInteger bclon = new BigInteger("" + this.b);
        return new Rational(aclon, bclon);
    }

    public Rational multiply(Rational val) {
        BigInteger num = this.a.multiply(val.a);
        BigInteger deno = this.b.multiply(val.b);
        return new Rational(num, deno);
    }

    public Rational multiply(BigInteger val) {
        Rational val2 = new Rational(val, BigInteger.ONE);
        return this.multiply(val2);
    }

    public Rational multiply(int val) {
        BigInteger tmp = new BigInteger("" + val);
        return this.multiply(tmp);
    }

    public Rational pow(int exponent) {
        if (exponent == 0) {
            return new Rational(1, 1);
        }
        BigInteger num = this.a.pow(Math.abs(exponent));
        BigInteger deno = this.b.pow(Math.abs(exponent));
        if (exponent > 0) {
            return new Rational(num, deno);
        }
        return new Rational(deno, num);
    }

    public Rational pow(BigInteger exponent) throws NumberFormatException {
        if (exponent.compareTo(MAX_INT) == 1) {
            throw new NumberFormatException("Exponent " + exponent.toString() + " too large.");
        }
        if (exponent.compareTo(MIN_INT) == -1) {
            throw new NumberFormatException("Exponent " + exponent.toString() + " too small.");
        }
        return this.pow(exponent.intValue());
    }

    public Rational root(BigInteger r) throws NumberFormatException {
        if (r.compareTo(MAX_INT) == 1) {
            throw new NumberFormatException("Root " + r.toString() + " too large.");
        }
        if (r.compareTo(MIN_INT) == -1) {
            throw new NumberFormatException("Root " + r.toString() + " too small.");
        }
        int rthroot = r.intValue();
        if (this.compareTo(ZERO) == -1 && rthroot % 2 == 0) {
            throw new NumberFormatException("Negative basis " + this.toString() + " with odd root " + r.toString());
        }
        boolean flipsign = this.compareTo(ZERO) == -1 && rthroot % 2 != 0;
        Ifactor num = new Ifactor(this.a.abs());
        Ifactor deno = new Ifactor(this.b);
        Rational resul = num.root(rthroot).divide(deno.root(rthroot));
        if (flipsign) {
            return resul.negate();
        }
        return resul;
    }

    public Rational pow(Rational exponent) throws NumberFormatException {
        if (exponent.a.compareTo(BigInteger.ZERO) == 0) {
            return new Rational(1, 1);
        }
        Rational tmp = this.pow(exponent.a);
        return tmp.root(exponent.b);
    }

    public Rational divide(Rational val) {
        if (val.compareTo(ZERO) == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        BigInteger num = this.a.multiply(val.b);
        BigInteger deno = this.b.multiply(val.a);
        return new Rational(num, deno);
    }

    public Rational divide(BigInteger val) {
        if (val.compareTo(BigInteger.ZERO) == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        Rational val2 = new Rational(val, BigInteger.ONE);
        return this.divide(val2);
    }

    public Rational divide(int val) {
        if (val == 0) {
            throw new ArithmeticException("Dividing " + this.toString() + " through zero.");
        }
        Rational val2 = new Rational(val, 1);
        return this.divide(val2);
    }

    public Rational add(Rational val) {
        BigInteger num = this.a.multiply(val.b).add(this.b.multiply(val.a));
        BigInteger deno = this.b.multiply(val.b);
        return new Rational(num, deno);
    }

    public Rational add(BigInteger val) {
        Rational val2 = new Rational(val, BigInteger.ONE);
        return this.add(val2);
    }

    public Rational add(int val) {
        BigInteger val2 = this.a.add(this.b.multiply(new BigInteger("" + val)));
        return new Rational(val2, this.b);
    }

    public Rational negate() {
        return new Rational(this.a.negate(), this.b);
    }

    public Rational subtract(Rational val) {
        Rational val2 = val.negate();
        return this.add(val2);
    }

    public Rational subtract(BigInteger val) {
        Rational val2 = new Rational(val, BigInteger.ONE);
        return this.subtract(val2);
    }

    public Rational subtract(int val) {
        Rational val2 = new Rational(val, 1);
        return this.subtract(val2);
    }

    public static Rational binomial(Rational n, BigInteger m) {
        if (m.compareTo(BigInteger.ZERO) == 0) {
            return ONE;
        }
        Rational bin = n;
        BigInteger i = new BigInteger("2");
        while (i.compareTo(m) != 1) {
            bin = bin.multiply(n.subtract(i.subtract(BigInteger.ONE))).divide(i);
            i = i.add(BigInteger.ONE);
        }
        return bin;
    }

    public static Rational binomial(Rational n, int m) {
        if (m == 0) {
            return ONE;
        }
        Rational bin = n;
        for (int i = 2; i <= m; ++i) {
            bin = bin.multiply(n.subtract(i - 1)).divide(i);
        }
        return bin;
    }

    public static Rational hankelSymb(Rational n, int k) {
        if (k == 0) {
            return ONE;
        }
        if (k < 0) {
            throw new ArithmeticException("Negative parameter " + k);
        }
        Rational nkhalf = n.subtract(k).add(HALF);
        nkhalf = nkhalf.Pochhammer(2 * k);
        Factorial f = new Factorial();
        return nkhalf.divide(f.at(k));
    }

    public BigInteger numer() {
        return this.a;
    }

    public BigInteger denom() {
        return this.b;
    }

    public Rational abs() {
        return new Rational(this.a.abs(), this.b.abs());
    }

    public BigInteger floor() {
        if (this.b.compareTo(BigInteger.ONE) == 0) {
            return this.a;
        }
        if (this.a.compareTo(BigInteger.ZERO) > 0) {
            return this.a.divide(this.b);
        }
        return this.a.divide(this.b).subtract(BigInteger.ONE);
    }

    public BigInteger ceil() {
        if (this.b.compareTo(BigInteger.ONE) == 0) {
            return this.a;
        }
        if (this.a.compareTo(BigInteger.ZERO) > 0) {
            return this.a.divide(this.b).add(BigInteger.ONE);
        }
        return this.a.divide(this.b);
    }

    public BigInteger trunc() {
        if (this.b.compareTo(BigInteger.ONE) == 0) {
            return this.a;
        }
        return this.a.divide(this.b);
    }

    @Override
    public int compareTo(Rational val) {
        BigInteger left = this.a.multiply(val.b);
        BigInteger right = val.a.multiply(this.b);
        return left.compareTo(right);
    }

    @Override
    public int compareTo(BigInteger val) {
        Rational val2 = new Rational(val, BigInteger.ONE);
        return this.compareTo(val2);
    }

    public String toString() {
        if (this.b.compareTo(BigInteger.ONE) != 0) {
            return this.a.toString() + "/" + this.b.toString();
        }
        return this.a.toString();
    }

    public double doubleValue() {
        BigDecimal adivb = new BigDecimal(this.a).divide(new BigDecimal(this.b), MathContext.DECIMAL128);
        return adivb.doubleValue();
    }

    public float floatValue() {
        BigDecimal adivb = new BigDecimal(this.a).divide(new BigDecimal(this.b), MathContext.DECIMAL128);
        return adivb.floatValue();
    }

    public BigDecimal BigDecimalValue(MathContext mc) {
        BigDecimal n = new BigDecimal(this.a);
        BigDecimal d = new BigDecimal(this.b);
        return BigDecimalMath.scalePrec(n.divide(d, mc), mc);
    }

    public String toFString(int digits) {
        if (this.b.compareTo(BigInteger.ONE) != 0) {
            MathContext mc = new MathContext(digits, RoundingMode.DOWN);
            BigDecimal f = new BigDecimal(this.a).divide(new BigDecimal(this.b), mc);
            return f.toString();
        }
        return this.a.toString();
    }

    public Rational max(Rational val) {
        if (this.compareTo(val) > 0) {
            return this;
        }
        return val;
    }

    public Rational min(Rational val) {
        if (this.compareTo(val) < 0) {
            return this;
        }
        return val;
    }

    public Rational Pochhammer(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        if (n.compareTo(BigInteger.ZERO) == 0) {
            return ONE;
        }
        Rational res = new Rational(this.a, this.b);
        BigInteger i = BigInteger.ONE;
        while (i.compareTo(n) < 0) {
            res = res.multiply(this.add(i));
            i = i.add(BigInteger.ONE);
        }
        return res;
    }

    public Rational Pochhammer(int n) {
        return this.Pochhammer(new BigInteger("" + n));
    }

    public boolean isBigInteger() {
        return this.b.abs().compareTo(BigInteger.ONE) == 0;
    }

    public boolean isInteger() {
        if (!this.isBigInteger()) {
            return false;
        }
        return this.a.compareTo(MAX_INT) <= 0 && this.a.compareTo(MIN_INT) >= 0;
    }

    int intValue() {
        if (!this.isInteger()) {
            throw new NumberFormatException("cannot convert " + this.toString() + " to integer.");
        }
        return this.a.intValue();
    }

    BigInteger BigIntegerValue() {
        if (!this.isBigInteger()) {
            throw new NumberFormatException("cannot convert " + this.toString() + " to BigInteger.");
        }
        return this.a;
    }

    public boolean isIntegerFrac() {
        return this.a.compareTo(MAX_INT) <= 0 && this.a.compareTo(MIN_INT) >= 0 && this.b.compareTo(MAX_INT) <= 0 && this.b.compareTo(MIN_INT) >= 0;
    }

    public int signum() {
        return this.b.signum() * this.a.signum();
    }

    public Vector<BigInteger> cfrac() {
        if (this.signum() < 0) {
            throw new NumberFormatException("Unsupported cfrac for negative " + this);
        }
        Vector<BigInteger> cf = new Vector<BigInteger>();
        if (this.signum() != 0) {
            BigInteger[] nRem = this.a.divideAndRemainder(this.b);
            cf.add(nRem[0]);
            if (nRem[1].signum() != 0) {
                cf.addAll(new Rational(this.b, nRem[1]).cfrac());
            }
        }
        return cf;
    }

    public static BigInteger lcmDenom(Rational[] vals) {
        BigInteger l = BigInteger.ONE;
        for (int v = 0; v < vals.length; ++v) {
            l = BigIntegerMath.lcm(l, vals[v].b);
        }
        return l;
    }

    public static Rational harmonic(int n) {
        if (n < 1) {
            return new Rational(0, 1);
        }
        Rational a = new Rational(1, 1);
        for (int i = 2; i <= n; ++i) {
            a = a.add(new Rational(1, i));
        }
        return a;
    }

    protected void normalize() {
        BigInteger g = this.a.gcd(this.b);
        if (g.compareTo(BigInteger.ONE) > 0) {
            this.a = this.a.divide(g);
            this.b = this.b.divide(g);
        }
        if (this.b.compareTo(BigInteger.ZERO) == -1) {
            this.a = this.a.negate();
            this.b = this.b.negate();
        }
    }
}

