/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigSurd;
import ar.com.sdd.commons.util.math.BigSurdVec;
import ar.com.sdd.commons.util.math.Factorial;
import ar.com.sdd.commons.util.math.Rational;
import java.math.BigInteger;
import java.util.Scanner;

public class Wigner3j {
    public static void main(String[] args) {
        if (args[0].compareTo("6j") == 0) {
            try {
                String m1 = "6";
                String t1 = "1 2 -3 -1 5 6";
                String t2 = "4 -5 3 -4 -2 -6";
                Object j = "";
                for (int i = 1; i <= 6; ++i) {
                    j = (String)j + args[i] + " ";
                }
                BigSurdVec w = Wigner3j.wigner3j(m1, t1, t2, (String)j);
                System.out.println(w.toString());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else if (args[0].compareTo("9j") == 0) {
            try {
                String m1 = "9";
                String t1 = "1 3 2 4 6 5 7 9 8";
                String t2 = "2 8 5 6 3 9 7 4 1";
                Object j = "";
                for (int i = 1; i <= 9; ++i) {
                    j = (String)j + args[i] + " ";
                }
                BigSurdVec w = Wigner3j.wigner3j(m1, t1, t2, (String)j);
                System.out.println(w.toString());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else if (args[0].compareTo("3jm") == 0) {
            int j1 = new Integer(args[1]);
            int j2 = new Integer(args[2]);
            int j3 = new Integer(args[3]);
            int m1 = new Integer(args[4]);
            int m2 = new Integer(args[5]);
            int m3 = new Integer(args[6]);
            try {
                BigSurd w = Wigner3j.wigner3jm(j1, j2, j3, m1, m2, m3);
                System.out.println(w.toString());
                w = w.multiply(new BigSurd(j3 + 1, 1));
                System.out.println("CG factor sqrt" + (j3 + 1) + "sign " + (j2 - j2 - m3) / 2 + " " + w.toString());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println("usage:");
            System.out.println(args[0] + " 6j 2j1+1 2j2+1 2j3+1 2j4+1 2j5+1 2j6+1");
            System.out.println(args[0] + " 9j 2j1+1 2j2+1 2j3+1 2j4+1 2j5+1 2j6+1.. 2j9+1 ");
            System.out.println(args[0] + " 3jm 2j1+1 2j2+1 2j3+1 2m1+1 2m2+1 2m3+1 ");
        }
    }

    public static BigSurd wigner3jm(int j1, int j2, int j3, int m1, int m2, int m3) {
        Rational J1 = new Rational(j1, 2);
        Rational J2 = new Rational(j2, 2);
        Rational J3 = new Rational(j3, 2);
        Rational M1 = new Rational(m1, 2);
        Rational M2 = new Rational(m2, 2);
        Rational M3 = new Rational(m3, 2);
        return Wigner3j.wigner3jm(J1, J2, J3, M1, M2, M3);
    }

    public static BigSurdVec wigner3j(String m1, String t1, String t2, String j) {
        Scanner s = new Scanner(m1);
        int m = s.nextInt();
        if (m % 3 != 0) {
            throw new IllegalArgumentException("Angular momenta " + m + " not a multiple of three.");
        }
        int[] jvec = new int[m];
        int[] tvec = new int[2 * m];
        s = new Scanner(j);
        int ji = 0;
        while (s.hasNextInt() && ji < m) {
            jvec[ji++] = s.nextInt();
            if (jvec[ji - 1] >= 1) continue;
            throw new IllegalArgumentException("Illegal value " + jvec[ji - 1] + " for 2j+1.");
        }
        s = new Scanner(t1);
        int ti = 0;
        while (s.hasNextInt()) {
            tvec[ti++] = s.nextInt();
        }
        s = new Scanner(t2);
        while (s.hasNextInt()) {
            tvec[ti++] = s.nextInt();
        }
        if (ji % 3 != 0) {
            throw new IllegalArgumentException("j-count " + ji + " not a multiple of three.");
        }
        if (ti != 2 * ji) {
            throw new IllegalArgumentException("triad-count " + ti + " not twice j-count " + ji);
        }
        int[] jfreq = new int[m];
        for (ji = 0; ji < jfreq.length; ++ji) {
            jfreq[ji] = 0;
        }
        int[][] jhash = new int[m][2];
        ti = 0;
        while (ti < 2 * m) {
            int t = tvec[ti];
            if (t == 0 || Math.abs(t) > jvec.length) {
                throw new IllegalArgumentException("Triad index " + t + " out of bounds");
            }
            if (jfreq[Math.abs(t) - 1] >= 2) {
                throw new IllegalArgumentException("Node " + t + " referenced more than twice");
            }
            jhash[Math.abs((int)t) - 1][jfreq[Math.abs((int)t) - 1]] = ti++;
            int n = Math.abs(t) - 1;
            jfreq[n] = jfreq[n] + 1;
        }
        Rational[] J = new Rational[jvec.length];
        for (ji = 0; ji < jvec.length; ++ji) {
            J[ji] = new Rational(jvec[ji] - 1, 2);
        }
        int[] triadidx = new int[tvec.length];
        for (ti = 0; ti < tvec.length; ++ti) {
            triadidx[ti] = Math.abs(tvec[ti]) - 1;
        }
        Rational[] M = new Rational[J.length];
        return Wigner3j.wigner3j(tvec, J, M, triadidx);
    }

    private static BigSurdVec wigner3j(int[] tvec, Rational[] J, Rational[] M, int[] triadidx) {
        int ji;
        int nei2;
        int nei1;
        int triadr;
        int triadn;
        BigSurdVec res = new BigSurdVec();
        for (int t = 0; t < triadidx.length; t += 3) {
            if (J[triadidx[t]].subtract(J[triadidx[t + 1]]).abs().compareTo(J[triadidx[t + 2]]) > 0) {
                return res;
            }
            if (J[triadidx[t]].add(J[triadidx[t + 1]]).compareTo(J[triadidx[t + 2]]) >= 0) continue;
            return res;
        }
        int freeM = -1;
        int freeMrank = -1;
        for (int i = 0; i < triadidx.length; ++i) {
            if (M[triadidx[i]] != null) continue;
            triadn = i / 3;
            triadr = i % 3;
            nei1 = 3 * triadn + (triadr + 1) % 3;
            nei2 = 3 * triadn + (triadr + 2) % 3;
            if (M[triadidx[nei1]] != null && M[triadidx[nei2]] != null) {
                freeM = i;
                break;
            }
            Rational wt = J[triadidx[i]].multiply(2).add(1);
            if (M[triadidx[nei1]] == null) {
                wt = wt.multiply(J[triadidx[nei1]].multiply(2).add(1));
            }
            if (M[triadidx[nei2]] == null) {
                wt = wt.multiply(J[triadidx[nei2]].multiply(2).add(1));
            }
            int thiswt = wt.intValue();
            if (freeM >= 0 && thiswt >= freeMrank) continue;
            freeM = i;
            freeMrank = thiswt;
        }
        if (freeM >= 0 && M[triadidx[freeM]] == null) {
            Rational[] childM = new Rational[M.length];
            for (ji = 0; ji < M.length; ++ji) {
                if (M[ji] == null) continue;
                childM[ji] = M[ji];
            }
            triadn = freeM / 3;
            triadr = freeM % 3;
            nei1 = 3 * triadn + (triadr + 1) % 3;
            nei2 = 3 * triadn + (triadr + 2) % 3;
            if (M[triadidx[nei1]] == null || M[triadidx[nei2]] == null) {
                Rational newm = J[triadidx[freeM]].negate();
                while (newm.compareTo(J[triadidx[freeM]]) <= 0) {
                    childM[triadidx[freeM]] = tvec[freeM] > 0 ? newm : newm.negate();
                    res = res.add(Wigner3j.wigner3j(tvec, J, childM, triadidx));
                    newm = newm.add(Rational.ONE);
                }
            } else {
                Rational newm;
                Rational m1 = M[triadidx[nei1]];
                Rational m2 = M[triadidx[nei2]];
                if (tvec[nei1] < 0) {
                    m1 = m1.negate();
                }
                if (tvec[nei2] < 0) {
                    m2 = m2.negate();
                }
                Rational rational = newm = tvec[freeM] > 0 ? m1.add(m2).negate() : m1.add(m2);
                if (newm.abs().compareTo(J[triadidx[freeM]]) <= 0) {
                    childM[triadidx[freeM]] = newm;
                    res = res.add(Wigner3j.wigner3j(tvec, J, childM, triadidx));
                }
            }
            return res;
        }
        res = BigSurdVec.ONE;
        for (int ji2 = 0; ji2 < triadidx.length; ji2 += 3) {
            Rational m1 = M[triadidx[ji2]];
            Rational m2 = M[triadidx[ji2 + 1]];
            Rational m3 = M[triadidx[ji2 + 2]];
            if (tvec[ji2] < 0) {
                m1 = m1.negate();
            }
            if (tvec[ji2 + 1] < 0) {
                m2 = m2.negate();
            }
            if (tvec[ji2 + 2] < 0) {
                m3 = m3.negate();
            }
            if ((res = res.multiply(Wigner3j.wigner3jm(J[triadidx[ji2]], J[triadidx[ji2 + 1]], J[triadidx[ji2 + 2]], m1, m2, m3))).signum() != 0) continue;
            return BigSurdVec.ZERO;
        }
        Rational sig = new Rational();
        for (ji = 0; ji < J.length; ++ji) {
            sig = sig.add(J[ji]).subtract(M[ji]);
        }
        if (sig.a.abs().testBit(0)) {
            res = res.negate();
        }
        return res;
    }

    protected static BigSurd wigner3jm(Rational j1, Rational j2, Rational j3, Rational m1, Rational m2, Rational m3) {
        if (m1.add(m2).add(m3).signum() != 0) {
            return BigSurd.ZERO;
        }
        if (!j1.add(j2).add(j3).isBigInteger()) {
            return BigSurd.ZERO;
        }
        Rational j1m2 = j1.subtract(j2);
        if (j1m2.abs().compareTo(j3) > 0) {
            return BigSurd.ZERO;
        }
        Rational j1p2 = j1.add(j2);
        if (j1p2.abs().compareTo(j3) < 0) {
            return BigSurd.ZERO;
        }
        if (m1.abs().compareTo(j1) > 0 || m2.abs().compareTo(j2) > 0 || m3.abs().compareTo(j3) > 0) {
            return BigSurd.ZERO;
        }
        if (!(m1.subtract(j1).isBigInteger() && m2.subtract(j2).isBigInteger() && m3.subtract(j3).isBigInteger())) {
            return BigSurd.ZERO;
        }
        int j1j2jk = j1p2.subtract(j3).intValue();
        int j1m1k = j1.subtract(m1).intValue();
        int j2m2k = j2.add(m2).intValue();
        int jj2m1k = j3.subtract(j2).add(m1).intValue();
        int jj1m2k = j3.subtract(j1).subtract(m2).intValue();
        int k = Math.max(0, -jj2m1k);
        if ((k = Math.max(k, -jj1m2k)) > 0) {
            j1j2jk -= k;
            j1m1k -= k;
            j2m2k -= k;
            jj2m1k += k;
            jj1m2k += k;
        }
        Factorial f = new Factorial();
        Rational sumk = new Rational();
        while (true) {
            BigInteger d = f.at(k).multiply(f.at(j1j2jk)).multiply(f.at(j1m1k)).multiply(f.at(j2m2k)).multiply(f.at(jj2m1k)).multiply(f.at(jj1m2k));
            sumk = k % 2 == 0 ? sumk.add(new Rational(BigInteger.ONE, d)) : sumk.subtract(new Rational(BigInteger.ONE, d));
            ++jj2m1k;
            ++jj1m2k;
            if (--j1j2jk < 0 || --j1m1k < 0 || --j2m2k < 0) break;
            ++k;
        }
        if (j1m2.subtract(m3).intValue() % 2 != 0) {
            sumk = sumk.negate();
        }
        k = j1m2.add(j3).intValue();
        BigInteger s = f.at(k);
        k = j3.subtract(j1m2).intValue();
        s = s.multiply(f.at(k));
        k = j1p2.subtract(j3).intValue();
        s = s.multiply(f.at(k));
        k = j3.add(m3).intValue();
        s = s.multiply(f.at(k));
        k = j3.subtract(m3).intValue();
        s = s.multiply(f.at(k));
        k = j1.add(m1).intValue();
        s = s.multiply(f.at(k));
        k = j1.subtract(m1).intValue();
        s = s.multiply(f.at(k));
        k = j2.add(m2).intValue();
        s = s.multiply(f.at(k));
        k = j2.subtract(m2).intValue();
        s = s.multiply(f.at(k));
        k = j1p2.add(j3).intValue();
        Rational disc = new Rational(s, f.at(++k));
        return new BigSurd(sumk, disc);
    }
}

