/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.reflection;

import ar.com.sdd.commons.util.ObjectUtil;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.reflection.InstanceCreator;
import ar.com.sdd.commons.util.reflection.InstanceCreatorException;
import ar.com.sdd.commons.util.reflection.ObjectBuilderContext;
import ar.com.sdd.commons.util.reflection.ObjectBuilderException;
import ar.com.sdd.commons.util.xml.XMLTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectBuilder {
    private static Logger log = LogManager.getLogger(ObjectBuilder.class);
    public static final String TAG_ID = "id";
    public static final String TAG_NAME = "name";
    public static final String TAG_TYPE = "type";
    public static final String TAG_CLASS = "class";
    public static final String TAG_NULL = "null";
    public static final String TAG_VALUE = "value";
    public static final String TAG_CONTEXTVALUE = "contextValue";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ARGUMENT = "argument";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_COMPANY_EBF_API = "CompanyEbfApi";
    public static final String TYPE_BANK_EBF_API = "BankEbfApi";
    public static final String TYPE_BIG_DECIMAL = "BigDecimal";
    public static final String TYPE_DOUBLE_PRIMITIVE = "double";
    public static final String TYPE_MAP = "java.util.HashMap";
    private String name;
    private String id;
    private String objectClassName;
    private Object value;
    private boolean contextValue;
    private boolean isObjectValue;
    private boolean nullValue;
    private HashMap contextMap;
    private ArrayList<ObjectBuilder> arguments = null;

    public ObjectBuilder(XMLTag configuration) throws ObjectBuilderException {
        this(configuration, null);
    }

    public ObjectBuilder(XMLTag configuration, Map contextMap) throws ObjectBuilderException {
        this(configuration, new HashMap(contextMap));
    }

    public ObjectBuilder(XMLTag configuration, HashMap contextMap) throws ObjectBuilderException {
        if (!ObjectBuilder.describesAnyValue(configuration) && (configuration = configuration.getFirstLevelChild()) == null) {
            throw new ObjectBuilderException("ObjectBuilder: configuracion no describe AnyValue, y contenido null");
        }
        this.setContextMap(contextMap);
        this.setId(configuration.getProperty(TAG_ID));
        this.setName(configuration.getProperty(TAG_NAME));
        this.setContextValue(ObjectBuilder.getBooleanAttribute(configuration, TAG_CONTEXTVALUE, false));
        this.setNullValue(ObjectBuilder.getBooleanAttribute(configuration, TAG_NULL, false));
        boolean bl = this.isObjectValue = !ObjectBuilder.describesPrimitiveValue(configuration);
        if (this.isObjectValue) {
            this.initializeObject(configuration);
        } else {
            this.initializePrimitive(configuration);
        }
    }

    public static boolean describesPrimitiveValue(XMLTag argumentTag) {
        return argumentTag.getProperty(TAG_TYPE) != null;
    }

    public static boolean describesObjectValue(XMLTag argumentTag) {
        return argumentTag.getProperty(TAG_CLASS) != null;
    }

    public static boolean describesNullObjectValue(XMLTag argumentTag) {
        return ObjectBuilder.getBooleanAttribute(argumentTag, TAG_NULL, false);
    }

    public static boolean describesAnyValue(XMLTag argumentTag) {
        return ObjectBuilder.describesObjectValue(argumentTag) || ObjectBuilder.describesPrimitiveValue(argumentTag) || ObjectBuilder.describesNullObjectValue(argumentTag);
    }

    private static boolean getBooleanAttribute(XMLTag tag, String attrName, boolean defaultValue) {
        String boolString = tag.getProperty(attrName);
        if (boolString != null) {
            return Boolean.valueOf(boolString);
        }
        return defaultValue;
    }

    private void initializePrimitive(XMLTag argumentTag) throws ObjectBuilderException {
        this.setObjectClassName(argumentTag.getProperty(TAG_TYPE));
        if (this.getObjectClassName().equals("xml") || this.getObjectClassName().equals("XMLTag") || this.getObjectClassName().equals(XMLTag.class.getName())) {
            this.setValue(argumentTag);
        } else if (this.getObjectClassName().equalsIgnoreCase("cdata")) {
            this.setObjectClassName(TYPE_STRING);
            this.setValue(argumentTag.getData());
        } else if (this.getObjectClassName().equalsIgnoreCase("context")) {
            this.setObjectClassName(TYPE_MAP);
            this.setValue(this.getContextMap());
        } else {
            this.setValue(argumentTag.getProperty(TAG_VALUE));
        }
    }

    private void initializeObject(XMLTag argumentTag) throws ObjectBuilderException {
        this.setObjectClassName(argumentTag.getProperty(TAG_CLASS));
        if (!this.isNullValue()) {
            this.initializeObjectArguments(argumentTag);
        }
    }

    private void initializeObjectArguments(XMLTag argumentsTag) throws ObjectBuilderException {
        this.arguments = new ArrayList();
        if (argumentsTag != null) {
            ArrayList<XMLTag> argumentTags = argumentsTag.getItems(TAG_ARGUMENT, false);
            if ((argumentTags == null || argumentTags.isEmpty()) && (argumentsTag = argumentsTag.getItem(TAG_ARGUMENTS)) != null) {
                argumentTags = argumentsTag.getItems(TAG_ARGUMENT, false);
            }
            if (argumentTags != null) {
                this.arguments.ensureCapacity(argumentTags.size());
                for (XMLTag argumentTag : argumentTags) {
                    try {
                        ObjectBuilder argument = new ObjectBuilder(argumentTag, this.getContextMap());
                        ObjectUtil.arraySet(this.arguments, argument.getId(), argument);
                    }
                    catch (Exception e) {
                        log.error("Ha ocurrido un error", (Throwable)e);
                    }
                }
            }
        }
    }

    public Object createObject() throws ObjectBuilderException {
        return this.createObject(null);
    }

    public Object createObject(ObjectBuilderContext context) throws ObjectBuilderException {
        if (this.isNullValue()) {
            return null;
        }
        if (this.isContextValue()) {
            return this.getValue();
        }
        try {
            InstanceCreator instanciator = new InstanceCreator();
            instanciator.setInstanceClassName(this.getObjectClassName());
            if (this.isObjectValue()) {
                this.setInstanciatorObjectArgs(instanciator, context);
            } else {
                this.setInstanciatorPrimitiveArgs(instanciator, context);
            }
            return instanciator.createInstance();
        }
        catch (Exception e) {
            throw new ObjectBuilderException("Ocurrio una excepcion al crear la instancia de " + this.getObjectClassName(), e);
        }
    }

    private void setInstanciatorPrimitiveArgs(InstanceCreator instanciator, ObjectBuilderContext context) throws InstanceCreatorException {
        if (this.getValue() instanceof XMLTag) {
            instanciator.addArgument(XMLTag.class.getName(), this.getValue());
        } else if (this.getValue() instanceof HashMap) {
            instanciator.addArgument(HashMap.class.getName(), this.getValue());
        } else {
            String theValue = (String)this.getValue();
            if (context != null) {
                theValue = ObjectBuilder.contextReplace(context, theValue);
            }
            instanciator.addArgument(TYPE_STRING, theValue);
        }
    }

    public static String contextReplace(ObjectBuilderContext context, String theValue) {
        int substFrom = 0;
        while ((substFrom = ((String)theValue).indexOf("${", substFrom)) >= 0) {
            String tag;
            int substTo = ((String)theValue).indexOf("}", substFrom);
            String key = tag = ((String)theValue).substring(substFrom + 2, substTo);
            boolean padd = false;
            int lengthPadd = 0;
            String typePadd = null;
            int charPadd = 32;
            if (key.indexOf(",") > 0) {
                padd = true;
                String[] params = key.split("[,]");
                String value = params[0];
                lengthPadd = Integer.parseInt(params[1]);
                typePadd = params[2].equalsIgnoreCase("N") ? "PADD_LEFT" : "PADD_RIGHT";
                charPadd = params[2].equalsIgnoreCase("N") ? 48 : 32;
                key = value;
            }
            String substFmt = null;
            if (key.indexOf(":") > 0) {
                int fmtPos = key.indexOf(":");
                substFmt = key.substring(fmtPos + 1);
                key = key.substring(0, fmtPos);
            }
            boolean keyFounded = true;
            Object value = ObjectUtil.safeToString(context.getContextValue(key), null);
            if (value == null) {
                value = "${" + tag + "}";
                keyFounded = false;
            } else {
                if (substFmt != null) {
                    value = String.format(substFmt, value);
                }
                if (padd) {
                    value = StringUtil.padd((String)value, lengthPadd, (char)charPadd, typePadd);
                }
            }
            theValue = ((String)theValue).substring(0, substFrom) + (String)value + ((String)theValue).substring(substTo + 1);
            if (keyFounded) continue;
            ++substFrom;
        }
        return theValue;
    }

    private void setInstanciatorObjectArgs(InstanceCreator instanciator, ObjectBuilderContext context) throws ObjectBuilderException {
        try {
            for (ObjectBuilder argument : this.arguments) {
                if (argument == null) continue;
                instanciator.addArgument(argument.getObjectClassName(), argument.createObject(context));
            }
        }
        catch (InstanceCreatorException e) {
            throw new ObjectBuilderException("Error al definir agrumentos al crear una instancia de " + this.getObjectClassName(), e);
        }
    }

    public void setContextArgumentValue(String name, Object value) {
        if (this.isContextValue() && this.getName().equals(name)) {
            this.setValue(value);
        }
        if (this.arguments != null) {
            for (ObjectBuilder argument : this.arguments) {
                if (argument == null) continue;
                argument.setContextArgumentValue(name, value);
            }
        }
    }

    public ArrayList<ObjectBuilder> getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList<ObjectBuilder> arguments) {
        this.arguments = arguments;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    public boolean isContextValue() {
        return this.contextValue;
    }

    public void setContextValue(boolean contextValue) {
        this.contextValue = contextValue;
    }

    public boolean isObjectValue() {
        return this.isObjectValue;
    }

    public void setObjectValue(boolean isObjectValue) {
        this.isObjectValue = isObjectValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public void setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
    }

    public void setContextMap(Map contextMap) {
        this.contextMap = new HashMap();
        this.contextMap.putAll(contextMap);
    }

    public void setContextMap(HashMap contextMap) {
        this.contextMap = contextMap;
    }

    public HashMap getContextMap() {
        if (this.contextMap != null) {
            return this.contextMap;
        }
        return new HashMap();
    }
}

