/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPEncryptor {
    private static Logger log = LogManager.getLogger(PGPEncryptor.class);
    private static int jceProvider = Security.addProvider((Provider)new BouncyCastleProvider());

    public static void encryptStream(InputStream sourceIn, long sourceInLength, String sourceFileName, OutputStream targetOut, InputStream privateKeyIn, char[] privateKeyPass, InputStream publicKeyIn) {
        try {
            int DEFAULT_BUFFER_SIZE = 2048;
            PGPSecretKey secretKey = PGPEncryptor.readSecretKey(privateKeyIn);
            PGPPrivateKey signingKey = secretKey.extractPrivateKey(privateKeyPass, "BC");
            OutputStream compressedOut = null;
            OutputStream literalOut = null;
            BufferedInputStream in = null;
            File literalDataFile = null;
            int bytesRead = 0;
            byte[] buffer = null;
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            PGPSignatureGenerator signGen = new PGPSignatureGenerator(secretKey.getPublicKey().getAlgorithm(), 2, "BC");
            signGen.initSign(0, signingKey);
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
            compressedOut = compressedDataGenerator.open((OutputStream)tmpOut);
            PGPOnePassSignature onePassSignature = signGen.generateOnePassVersion(false);
            onePassSignature.encode(compressedOut);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            literalOut = literalDataGenerator.open(compressedOut, 'b', sourceFileName, sourceInLength, new Date());
            in = new BufferedInputStream(sourceIn, DEFAULT_BUFFER_SIZE);
            buffer = new byte[DEFAULT_BUFFER_SIZE];
            bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                literalOut.write(buffer, 0, bytesRead);
                signGen.update(buffer, 0, bytesRead);
            }
            signGen.generate().encode(compressedOut);
            literalDataGenerator.close();
            compressedDataGenerator.close();
            if (compressedOut != null) {
                compressedOut.close();
            }
            if (tmpOut != null) {
                tmpOut.close();
            }
            if (literalOut != null) {
                literalOut.close();
            }
            if (in != null) {
                in.close();
            }
            OutputStream out = null;
            BufferedInputStream literalIn = null;
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(3, true, new SecureRandom(), "BC");
            encryptedDataGenerator.addMethod(PGPEncryptor.readPublicKey(publicKeyIn));
            out = new BufferedOutputStream(targetOut, DEFAULT_BUFFER_SIZE);
            out = new ArmoredOutputStream(out);
            byte[] tmpBytes = tmpOut.toByteArray();
            out = encryptedDataGenerator.open(out, (long)tmpBytes.length);
            literalIn = new BufferedInputStream(new ByteArrayInputStream(tmpBytes), DEFAULT_BUFFER_SIZE);
            bytesRead = 0;
            while ((bytesRead = ((InputStream)literalIn).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            encryptedDataGenerator.close();
            if (out != null) {
                out.close();
            }
            if (literalIn != null) {
                ((InputStream)literalIn).close();
            }
            if (literalDataFile != null) {
                literalDataFile.delete();
            }
            log.debug("Firma / Encriptacion del stream finalizada.");
        }
        catch (Exception e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
    }

    public static void decryptStream(InputStream in, InputStream privateKeyIn, char[] privateKeyPass, InputStream publicKeyIn) throws Exception {
        block17: {
            in = PGPUtil.getDecoderStream((InputStream)in);
            try {
                PGPObjectFactory pgpF = new PGPObjectFactory(in);
                Object o = pgpF.nextObject();
                PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
                Iterator it = enc.getEncryptedDataObjects();
                PGPPrivateKey sKey = null;
                PGPPublicKeyEncryptedData pbe = null;
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    sKey = PGPEncryptor.findSecretKey(privateKeyIn, pbe.getKeyID(), privateKeyPass);
                }
                if (sKey == null) {
                    throw new IllegalArgumentException("No se encontro la clave privada para el mensaje.");
                }
                InputStream clear = pbe.getDataStream(sKey, "BC");
                PGPObjectFactory plainFact = new PGPObjectFactory(clear);
                Object message = plainFact.nextObject();
                PGPObjectFactory pgpFact = null;
                if (message instanceof PGPCompressedData) {
                    PGPCompressedData cData = (PGPCompressedData)message;
                    pgpFact = new PGPObjectFactory(cData.getDataStream());
                    message = pgpFact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    int ch;
                    PGPLiteralData ld = (PGPLiteralData)message;
                    BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(ld.getFileName()));
                    InputStream unc = ld.getInputStream();
                    while ((ch = unc.read()) >= 0) {
                        ((OutputStream)fOut).write(ch);
                    }
                } else if (message instanceof PGPOnePassSignatureList) {
                    int ch;
                    PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)message;
                    PGPOnePassSignature ops = sigList.get(0);
                    PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
                    InputStream dIn = p2.getInputStream();
                    String newFileName = p2.getFileName();
                    if (newFileName == null || newFileName.equals("")) {
                        newFileName = "salida.out";
                    }
                    BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(newFileName));
                    PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)publicKeyIn));
                    PGPPublicKey pubKey = pgpRing.getPublicKey(ops.getKeyID());
                    ops.initVerify(pubKey, "BC");
                    while ((ch = dIn.read()) >= 0) {
                        ops.update((byte)ch);
                        ((OutputStream)fOut).write((byte)ch);
                    }
                    PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
                    if (!ops.verify(p3.get(0))) {
                        throw new SignatureException("La firma es incorrecta.");
                    }
                    log.debug("Firma verificada con exito.");
                } else {
                    throw new PGPException("El mensaje no contiene un tipo PGP conocido.");
                }
                if (pbe.isIntegrityProtected()) {
                    if (!pbe.verify()) {
                        log.debug("Chequeo de integridad fallido!");
                    } else {
                        log.debug("Chequeo de integridad exitoso");
                    }
                } else {
                    log.debug("No se chequea integridad");
                }
            }
            catch (PGPException e) {
                log.error("Ha ocurrido un error", (Throwable)e);
                if (e.getUnderlyingException() == null) break block17;
                log.error((Object)e.getUnderlyingException());
            }
        }
    }

    private static PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(in);
        PGPPublicKey key = null;
        Iterator rIt = pgpPub.getKeyRings();
        while (key == null && rIt.hasNext()) {
            PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
            Iterator kIt = kRing.getPublicKeys();
            while (key == null && kIt.hasNext()) {
                PGPPublicKey k = (PGPPublicKey)kIt.next();
                if (!k.isEncryptionKey()) continue;
                key = k;
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("No se encontro la clave publica en el key ring.");
        }
        return key;
    }

    private static PGPSecretKey readSecretKey(InputStream in) throws IOException, PGPException {
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(in);
        PGPSecretKey key = null;
        Iterator rIt = pgpSec.getKeyRings();
        while (key == null && rIt.hasNext()) {
            PGPSecretKeyRing kRing = (PGPSecretKeyRing)rIt.next();
            Iterator kIt = kRing.getSecretKeys();
            while (key == null && kIt.hasNext()) {
                PGPSecretKey k = (PGPSecretKey)kIt.next();
                if (!k.isSigningKey()) continue;
                key = k;
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("No se encontro la clave privada en el keyring.");
        }
        return key;
    }

    public static PGPPrivateKey findSecretKey(InputStream keyIn, long keyID, char[] pass) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn));
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(pass, "BC");
    }
}

