/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPHelper {
    public PGPSecretKey readSecretKey(String keyFileName) throws IOException, PGPException {
        return this.readSecretKey(keyFileName, null);
    }

    public PGPSecretKey readSecretKey(String keyFileName, PGPPublicKeyEncryptedData publicKeyData) throws IOException, PGPException {
        try (FileInputStream keyStream = new FileInputStream(keyFileName);){
            PGPSecretKey pGPSecretKey = this.readSecretKey(keyStream, publicKeyData);
            return pGPSecretKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPSecretKey readSecretKey(InputStream inKey, PGPPublicKeyEncryptedData publicKeyData) throws IOException, PGPException {
        PGPSecretKey key = null;
        try (InputStream in = PGPUtil.getDecoderStream((InputStream)inKey);){
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(in);
            if (publicKeyData == null) {
                Iterator rIt = pgpSec.getKeyRings();
                while (key == null && rIt.hasNext()) {
                    PGPSecretKeyRing kRing = (PGPSecretKeyRing)rIt.next();
                    Iterator kIt = kRing.getSecretKeys();
                    while (key == null && kIt.hasNext()) {
                        PGPSecretKey k = (PGPSecretKey)kIt.next();
                        if (!k.isSigningKey()) continue;
                        key = k;
                    }
                }
            } else {
                key = pgpSec.getSecretKey(publicKeyData.getKeyID());
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("No se encontro la clave privada en el keyring.");
        }
        return key;
    }

    public PGPPublicKey readPublicKey(String keyFileName) throws IOException, PGPException {
        return this.readPublicKey(keyFileName, null);
    }

    public PGPPublicKey readPublicKey(String keyFileName, PGPOnePassSignature signature) throws IOException, PGPException {
        try (FileInputStream keyStream = new FileInputStream(keyFileName);){
            PGPPublicKey pGPPublicKey = this.readPublicKey(keyStream, signature);
            return pGPPublicKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPPublicKey readPublicKey(InputStream inKey, PGPOnePassSignature signature) throws IOException, PGPException {
        PGPPublicKey key = null;
        try (InputStream in = PGPUtil.getDecoderStream((InputStream)inKey);){
            PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(in);
            if (signature == null) {
                Iterator rIt = pgpPub.getKeyRings();
                while (key == null && rIt.hasNext()) {
                    PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
                    Iterator kIt = kRing.getPublicKeys();
                    while (key == null && kIt.hasNext()) {
                        PGPPublicKey k = (PGPPublicKey)kIt.next();
                        if (!k.isEncryptionKey()) continue;
                        key = k;
                    }
                }
            } else {
                key = pgpPub.getPublicKey(signature.getKeyID());
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("No se encontro la clave publica en el keyring.");
        }
        return key;
    }

    public PGPPrivateKey getPrivateKey(PGPSecretKey key, char[] passphrase) throws PGPException {
        try {
            return key.extractPrivateKey(passphrase, "BC");
        }
        catch (NoSuchProviderException e) {
            throw new PGPException("Faltan agregar en el classpath los JARs de BouncyCastle", (Exception)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

