/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.xml.AbstractHandler;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HierarchicalHandler
extends AbstractHandler {
    private LinkedList handlerStack = new LinkedList();
    private LinkedList tagStack = new LinkedList();

    public HierarchicalHandler(Object handler) {
        this.pushHandler(handler, "");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            Object subHandler = this.startElement(this.currentHandler(), uri, localName, qName, attributes);
            if (subHandler != null) {
                this.pushHandler(subHandler, this.getElementName(localName, qName));
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        catch (Throwable ex) {
            this.error("", ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endElement(this.currentHandler(), uri, localName, qName);
            String tagName = this.getElementName(localName, qName);
            if (tagName.equals(this.currentHandlerRootTag())) {
                this.popHandler();
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        catch (Throwable ex) {
            this.error("", ex);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            this.characters(this.currentHandler(), chars, start, length);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        catch (Throwable ex) {
            this.error("", ex);
        }
    }

    private void pushHandler(Object handler, String tag) {
        this.tagStack.addFirst(tag);
        this.handlerStack.addFirst(handler);
    }

    private Object popHandler() {
        this.tagStack.removeFirst();
        return this.handlerStack.removeFirst();
    }

    private Object currentHandler() {
        return this.handlerStack.getFirst();
    }

    private String currentHandlerRootTag() {
        return (String)this.tagStack.getFirst();
    }
}

