/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.xml.XMLDataException;
import ar.com.sdd.commons.util.xml.XMLDataHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataNoTree {
    private XMLDataHandler xmlDataHandler;

    public XMLDataNoTree(XMLDataHandler xmlDataHandler) {
        this.xmlDataHandler = xmlDataHandler;
    }

    public void parse(InputStream xmlDocument) throws XMLDataException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            try {
                saxParser.parse(xmlDocument, (DefaultHandler)this.xmlDataHandler);
            }
            catch (SAXException ex) {
                throw new XMLDataException("Error al parsear el documento [" + xmlDocument + "]", ex, false);
            }
            catch (IOException ex) {
                throw new XMLDataException("Error al leer el documento [" + xmlDocument + "]", ex, false);
            }
        }
        catch (SAXException ex) {
            throw new XMLDataException("Error al inicializar el parser para el documento [" + xmlDocument + "]", ex, true);
        }
        catch (ParserConfigurationException ex) {
            throw new XMLDataException("Error de configuracion en el parser para el documento [" + xmlDocument + "]", ex, true);
        }
    }

    public void parse(String xmlDocument) throws XMLDataException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            try {
                saxParser.parse(new File(xmlDocument), (DefaultHandler)this.xmlDataHandler);
            }
            catch (SAXException ex) {
                throw new XMLDataException("Error al parsear el documento [" + xmlDocument + "]", ex, false);
            }
            catch (IOException ex) {
                throw new XMLDataException("Error al leer el documento [" + xmlDocument + "]", ex, false);
            }
        }
        catch (SAXException ex) {
            throw new XMLDataException("Error al inicializar el parser para el documento [" + xmlDocument + "]", ex, true);
        }
        catch (ParserConfigurationException ex) {
            throw new XMLDataException("Error de configuracion en el parser para el documento [" + xmlDocument + "]", ex, true);
        }
    }

    class XMLErrorHandler
    implements ErrorHandler {
        XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLDataNoTree.class);
            log.error("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")", (Throwable)e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLDataNoTree.class);
            log.fatal("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")", (Throwable)e);
        }

        @Override
        public void warning(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLDataNoTree.class);
            log.warn("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")");
        }
    }
}

