package ar.com.sdd.commons.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Map;

public class PropertiesMapUtil {

	private static final Logger log = LogManager.getLogger(PropertiesMapUtil.class);
	Map<String, String> properties;

	public PropertiesMapUtil(Map<String, String> properties) {
		this.properties = properties;
	}

	public String get(String key, String ...suffix) {
		String lastFound = properties.get(key);
		String lastKey = key;
		for(String s:suffix) {
			lastKey+="."+s;
			String value = properties.get(lastKey);
			if (value!=null) lastFound=value;
		}
		return lastFound;
	}

}