package ar.com.sdd.commons.util.xml;

import java.util.Map;

public class XMLStringBuilder {

	private StringBuilder xmlBody;
	
	public void newXML()
	{
		xmlBody = new StringBuilder();
	}
	
	public void setOpeningTag(String tagName)
	{
		xmlBody.append("<" + tagName + ">");
	}
	public void setClosingTag(String tagName)
	{
		xmlBody.append("</" + tagName + ">");
	}
	public void setEmptyTag(String tagName)
	{
		xmlBody.append("<" + tagName + "/>");
	}
	
	public void setTag(String tagName,Object tagValue)
	{
		if(tagValue == null)
		{
			this.setEmptyTag(tagName);
		}
		else
		{
			this.setOpeningTag(tagName);
			xmlBody.append(tagValue.toString());
			this.setClosingTag(tagName);			
		}
	}
	
	public void setTag(String tagName,Map tagValues) //Pone en el tag, el valor con el tagName como clave en el mapa
	{
		if(!tagValues.containsKey(tagName))
		{
			this.setEmptyTag(tagName);	
		}
		else
		{
			Object tagValue = tagValues.get(tagName);
			this.setTag(tagName,tagValue);	
		}
	}
	
	public String getXMLString()
	{
		if(xmlBody == null)
			return null;
		return this.xmlBody.toString();
	}
	
	public String toString()
	{
		return this.getXMLString();
	}
}
