package ar.com.sdd.commons.util;

import java.util.ArrayList;
import java.util.List;

public class FixedFormatter {

	List fields;

	boolean throwExceptionOnDataLost;

	boolean compiled;

	int resultLenght;

	int[] fieldLenght;

	String[] fieldPaddingType;

	char[] fieldPaddingChar;

	public FixedFormatter() {
		super();
		fields = new ArrayList();
		throwExceptionOnDataLost = false;
		compiled = false;
	}

	public void addField(int length) {
		this.addField(length, StringUtil.PADD_RIGHT, ' ');
	}

	public void addField(int length, String paddingType) {
		this.addField(length, paddingType, ' ');
	}

	public void addField(int length, String paddingType, char paddingChar) {
		compiled = false;
		fields.add(new Object[] { Integer.valueOf(length), paddingType, Character.valueOf(paddingChar) });
	}

	public void setThrowExceptionOnDataLost(boolean throwExceptionOnDataLost) {
		this.throwExceptionOnDataLost = throwExceptionOnDataLost;
	}

	private void compile() {
		resultLenght = 0;
		fieldLenght = new int[fields.size()];
		fieldPaddingType = new String[fields.size()];
		fieldPaddingChar = new char[fields.size()];

		for (int i = 0; i < fields.size(); i++) {
			Object[] tok = (Object[]) fields.get(i);
			int length = ((Integer) tok[0]).intValue();
			resultLenght += length;
			fieldLenght[i] = length;
			fieldPaddingType[i] = (String) tok[1];
			fieldPaddingChar[i] = ((Character) tok[2]).charValue();
		}
		compiled = true;
	}

	public String format(Object[] array) {
		if (array == null) throw new NullPointerException();

		if (compiled == false) compile();

		StringBuilder str = new StringBuilder(resultLenght);
		for (int i = 0; i < fields.size(); i++) {
			Object v = null;
			if (i < array.length) v = array[i];
			String s;
			if (v instanceof String)
				s = (String) v;
			else
				s = v.toString();
			if (s != null && throwExceptionOnDataLost && s.length() > fieldLenght[i]) {
				throw new RuntimeException("Campo " + i + " excede el tama#o previsto.");
			}
			s = StringUtil.padd(s, fieldLenght[i], fieldPaddingChar[i], fieldPaddingType[i]);
			str.append(s);
		}
		return str.toString();
	}
}
