package ar.com.sdd.commons.util;

import javax.xml.bind.DatatypeConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;


/**
 * Encriptacion y manejo de passwords.
 */
public class PasswordUtil {
	
	// Es un singleton
	private static PasswordUtil instance;

	
	public static synchronized PasswordUtil getInstance() {
		if (instance == null) instance = new PasswordUtil(); 
		return instance;
	}


	//---------------------------------------------------------------------------------//
	
	/**
	 * Singleton.
	 */
	private PasswordUtil() {}
	
	
	/**
	 * Encripcion "one-way" de la password, mediante el algoritmo de hash SHA-1.
	 * Sin importar la longitud del String de entrada, produce hashs de salida 
	 * de longitud 28.
	 *
	 * Si el string de entrada es null, devuelve null.
	 */
	public synchronized String hashPassword(String password) throws ApplicationException {
		
		MessageDigest messageDigest = null;
	
		if (password == null) return null;

		if (password.length()>100) password=password.substring(0,100);
		try {
	  		
	  		messageDigest = MessageDigest.getInstance("SHA");
	  		
		} catch (NoSuchAlgorithmException ex) {
	  		throw new ApplicationException("Error de encripcion: " + ex.getMessage());
		}
				
  		messageDigest.update(password.getBytes(StandardCharsets.UTF_8));
	  		
		byte[] raw = messageDigest.digest();
		return  DatatypeConverter.printBase64Binary(raw);
	}
	
}
