/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigDecimalMath;
import ar.com.sdd.commons.util.math.BigIntegerPoly;
import ar.com.sdd.commons.util.math.BigSurd;
import ar.com.sdd.commons.util.math.RatPoly;
import ar.com.sdd.commons.util.math.Rational;
import ar.com.sdd.commons.util.math.RationalPoly;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Vector;

public class BigSurdVec
implements Comparable<BigSurdVec> {
    public static BigSurdVec ZERO = new BigSurdVec();
    public static BigSurdVec ONE = new BigSurdVec(BigSurd.ONE);
    Vector<BigSurd> terms;

    public BigSurdVec() {
        this.terms = new Vector();
    }

    public BigSurdVec(BigSurd a) {
        this.terms = new Vector(1);
        this.terms.add(a);
    }

    public BigSurdVec(BigSurd a, BigSurd b) {
        this.terms = new Vector(2);
        this.terms.add(a);
        this.terms.add(b);
        this.normalize();
    }

    public BigSurdVec(Vector<BigInteger> a) throws NumberFormatException {
        if (a.size() == 0) {
            throw new NumberFormatException("Empty periodic continued fraction");
        }
        RationalPoly x = new RationalPoly(BigIntegerPoly.X, BigIntegerPoly.ONE);
        for (int i = 0; i < a.size(); ++i) {
            x = x.minus(a.elementAt(i)).inverse();
        }
        RatPoly defeq = x.b.multiply(BigIntegerPoly.X).subtract(x.a);
        this.terms = new Vector();
        switch (defeq.degree()) {
            case 0: {
                throw new NumberFormatException("Non-definitive periodic continued fraction");
            }
            case 1: {
                Rational a0a1 = defeq.at(0).negate().divide(defeq.at(1));
                BigSurd loneterm = new BigSurd(a0a1, Rational.ONE);
                this.terms.add(loneterm);
                break;
            }
            case 2: {
                Rational a1 = defeq.at(1).divide(defeq.at(2));
                Rational a0 = defeq.at(0).divide(defeq.at(2));
                a1 = a1.negate().divide(2);
                BigSurd loneterm = new BigSurd(a1, Rational.ONE);
                this.terms.add(loneterm);
                loneterm = new BigSurd(Rational.ONE, a1.pow(2).subtract(a0));
                this.terms.add(loneterm);
                this.normalize();
                break;
            }
            default: {
                throw new NumberFormatException("Internal error " + defeq);
            }
        }
    }

    protected void normalize() {
        if (this.terms.size() <= 1) {
            return;
        }
        Vector<BigSurd> newter = new Vector<BigSurd>();
        newter.add(this.terms.firstElement());
        for (int j = 1; j < this.terms.size(); ++j) {
            BigSurd todo = this.terms.elementAt(j);
            boolean merged = false;
            for (int ex = 0; ex < newter.size(); ++ex) {
                BigSurd v = (BigSurd)newter.elementAt(ex);
                BigSurd r = todo.divide(v);
                if (!r.isRational()) continue;
                Rational newpref = r.toRational().add(1);
                if (newpref.compareTo(Rational.ZERO) == 0) {
                    newter.removeElementAt(ex);
                } else {
                    v = v.multiply(newpref);
                    newter.setElementAt(v, ex);
                }
                merged = true;
                break;
            }
            if (merged) continue;
            newter.add(todo);
        }
        this.terms = newter;
    }

    @Override
    public int compareTo(BigSurdVec oth) {
        BigSurdVec diff = this.subtract(oth);
        return diff.signum();
    }

    public int signum() {
        int offsig;
        if (this.terms.size() == 0) {
            return 0;
        }
        if (this.terms.size() == 1) {
            return this.terms.firstElement().signum();
        }
        int sig0 = this.terms.elementAt(0).signum();
        for (offsig = 1; offsig < this.terms.size() && this.terms.elementAt(offsig).signum() == sig0; ++offsig) {
        }
        if (offsig >= this.terms.size()) {
            return sig0;
        }
        if (this.terms.size() == 2) {
            return this.terms.elementAt(0).compareTo(this.terms.elementAt(1).negate());
        }
        if (this.terms.size() == 3) {
            BigSurdVec lhs = offsig == 2 ? new BigSurdVec(this.terms.elementAt(0), this.terms.elementAt(1)) : new BigSurdVec(this.terms.elementAt(0), this.terms.elementAt(2));
            lhs = lhs.sqr();
            BigSurd rhs = new BigSurd(this.terms.elementAt(offsig).sqr(), Rational.ONE);
            if (lhs.compareTo(lhs) > 0) {
                return this.terms.elementAt(0).signum();
            }
            return this.terms.elementAt(offsig).signum();
        }
        return this.floatValue() > 0.0 ? 1 : -1;
    }

    public BigDecimal BigDecimalValue(MathContext mc) {
        if (this.terms.size() == 0) {
            return BigDecimal.ZERO;
        }
        if (this.terms.size() == 1) {
            return this.terms.firstElement().BigDecimalValue(mc);
        }
        BigDecimal[] res = new BigDecimal[2];
        res[0] = BigDecimal.ZERO;
        int addpr = 1;
        while (true) {
            BigDecimal err;
            int prec;
            MathContext locmc = new MathContext(mc.getPrecision() + addpr, mc.getRoundingMode());
            res[1] = this.terms.size() == 0 ? BigDecimal.ZERO : this.terms.firstElement().BigDecimalValue(locmc);
            for (int i = 1; i < this.terms.size(); ++i) {
                BigSurd j = this.terms.elementAt(i);
                res[1] = BigDecimalMath.addRound(res[1], j.BigDecimalValue(locmc));
            }
            if (addpr > 1 && (prec = BigDecimalMath.err2prec(res[1], err = res[1].subtract(res[0]).abs())) > mc.getPrecision()) break;
            res[0] = res[1];
            addpr += 3;
        }
        return BigDecimalMath.scalePrec(res[1], mc);
    }

    public double doubleValue() {
        BigDecimal bd = this.BigDecimalValue(MathContext.DECIMAL128);
        return bd.doubleValue();
    }

    public double floatValue() {
        BigDecimal bd = this.BigDecimalValue(MathContext.DECIMAL64);
        return bd.floatValue();
    }

    public BigSurdVec add(Rational val) {
        return this.add(new BigSurd(val, Rational.ONE));
    }

    public BigSurdVec add(BigSurdVec val) {
        BigSurdVec sum = new BigSurdVec();
        sum.terms.addAll(this.terms);
        sum.terms.addAll(val.terms);
        sum.normalize();
        return sum;
    }

    public BigSurdVec add(BigSurd val) {
        BigSurdVec sum = new BigSurdVec();
        sum.terms.addAll(this.terms);
        sum.terms.add(val);
        sum.normalize();
        return sum;
    }

    public BigSurdVec subtract(BigSurdVec val) {
        BigSurdVec sum = new BigSurdVec();
        sum.terms.addAll(this.terms);
        for (BigSurd s : val.terms) {
            sum.terms.add(s.negate());
        }
        sum.normalize();
        return sum;
    }

    public BigSurdVec subtract(BigSurd val) {
        BigSurdVec sum = new BigSurdVec();
        sum.terms.addAll(this.terms);
        sum.terms.add(val.negate());
        sum.normalize();
        return sum;
    }

    public BigSurdVec negate() {
        BigSurdVec resul = new BigSurdVec();
        for (BigSurd s : this.terms) {
            resul.terms.add(s.negate());
        }
        return resul;
    }

    public BigSurdVec sqr() {
        int i;
        BigSurdVec resul = new BigSurdVec();
        for (i = 0; i < this.terms.size(); ++i) {
            resul.terms.add(new BigSurd(this.terms.elementAt(i).sqr(), Rational.ONE));
        }
        for (i = 0; i < this.terms.size() - 1; ++i) {
            for (int j = i + 1; j < this.terms.size(); ++j) {
                resul.terms.add(this.terms.elementAt(i).multiply(this.terms.elementAt(j)).multiply(2));
            }
        }
        resul.normalize();
        return resul;
    }

    public BigSurdVec multiply(BigSurd val) {
        BigSurdVec resul = new BigSurdVec();
        for (BigSurd s : this.terms) {
            resul.terms.add(s.multiply(val));
        }
        resul.normalize();
        return resul;
    }

    public String toString() {
        if (this.terms.size() == 0) {
            return new String("0");
        }
        Object s = new String();
        for (int t = 0; t < this.terms.size(); ++t) {
            BigSurd bs = this.terms.elementAt(t);
            if (bs.signum() > 0) {
                s = (String)s + "+";
            }
            s = (String)s + bs.toString();
        }
        return s;
    }
}

