/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigComplex;
import ar.com.sdd.commons.util.math.BigIntegerMath;
import ar.com.sdd.commons.util.math.BigIntegerPoly;
import ar.com.sdd.commons.util.math.Factorial;
import ar.com.sdd.commons.util.math.Ifactor;
import ar.com.sdd.commons.util.math.Rational;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;

class RatPoly {
    protected Vector<Rational> a;
    public static final RatPoly ONE = new RatPoly("1");

    public RatPoly() {
        this.a = new Vector();
    }

    public RatPoly(Vector<Rational> L) {
        this.a = new Vector();
        for (int i = 0; i < L.size(); ++i) {
            this.a.add(L.elementAt(i).clone());
        }
        this.simplify();
    }

    public RatPoly(String L) throws NumberFormatException {
        this.a = new Vector();
        Scanner sc = new Scanner(L);
        sc.useDelimiter(",");
        while (sc.hasNext()) {
            String tok = sc.next();
            this.a.add(new Rational(tok));
        }
        this.simplify();
    }

    public RatPoly(Vector<BigInteger> A, Vector<BigInteger> B, int nmax) {
        this.init(A, B, nmax);
    }

    public RatPoly(Vector<BigInteger> A, Vector<BigInteger> B) {
        BigInteger Nmax = BigInteger.ONE.negate();
        for (int j = 0; j < A.size(); ++j) {
            if (A.elementAt(j).compareTo(BigInteger.ZERO) > 0) continue;
            Nmax = Nmax.compareTo(BigInteger.ZERO) < 0 ? A.elementAt(j).negate() : Nmax.min(A.elementAt(j).negate());
        }
        if (Nmax.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Infinite Number of Terms in Series " + Nmax.toString());
        }
        int nmax = Nmax.intValue() - 1;
        this.init(A, B, nmax);
    }

    protected void init(Vector<BigInteger> A, Vector<BigInteger> B, int nmax) {
        this.a = new Vector();
        Factorial f = new Factorial();
        for (int n = 0; n <= nmax; ++n) {
            int j;
            Rational c = new Rational(1, 1);
            for (j = 0; j < A.size(); ++j) {
                Rational aEl = new Rational(A.elementAt(j));
                c = c.multiply(aEl.Pochhammer(n));
            }
            for (j = 0; j < B.size(); ++j) {
                Rational bEl = new Rational(B.elementAt(j));
                c = c.divide(bEl.Pochhammer(n));
            }
            c = c.divide(f.at(n));
            this.a.add(c);
        }
        this.simplify();
    }

    public RatPoly clone() {
        RatPoly clo = new RatPoly();
        clo.a = (Vector)this.a.clone();
        return clo;
    }

    public Rational at(int n) {
        if (n < this.a.size()) {
            return this.a.elementAt(n);
        }
        return new Rational(0, 1);
    }

    public BigComplex valueOf(BigComplex x, MathContext mc) {
        BigComplex f = new BigComplex();
        for (int i = this.degree(); i >= 0; --i) {
            f = f.multiply(x, mc).add(this.a.elementAt(i).BigDecimalValue(mc));
        }
        return f;
    }

    public Rational valueOf(Rational x) {
        Rational f = new Rational(0, 1);
        for (int i = this.degree(); i >= 0; --i) {
            f = f.multiply(x).add(this.a.elementAt(i));
        }
        return f;
    }

    public Rational valueOf(int x) {
        return this.valueOf(new Rational(x, 1));
    }

    public Rational valueOf(BigInteger x) {
        return this.valueOf(new Rational(x));
    }

    public void set(int n, Rational value) {
        if (n < this.a.size()) {
            this.a.set(n, value);
        } else {
            while (this.a.size() < n) {
                this.a.add(new Rational(0, 1));
            }
            this.a.add(value);
        }
    }

    public void set(int n, BigInteger value) {
        Rational val2 = new Rational(value, BigInteger.ONE);
        this.set(n, val2);
    }

    public void set(int n, int value) {
        Rational val2 = new Rational(value, 1);
        this.set(n, val2);
    }

    public void setExp(int nmax) {
        this.a.clear();
        Factorial factorial = new Factorial();
        for (int n = 0; n <= nmax; ++n) {
            this.set(n, new Rational(BigInteger.ONE, factorial.at(n)));
        }
    }

    public void setx() {
        this.a.clear();
        this.a.add(new Rational(0, 1));
        this.a.add(new Rational(1, 1));
    }

    public int size() {
        return this.a.size();
    }

    public int degree() {
        return this.a.size() - 1;
    }

    public int ldegree() {
        for (int n = 0; n < this.a.size(); ++n) {
            if (this.a.elementAt(n).compareTo(BigInteger.ZERO) == 0) continue;
            return n;
        }
        return 0;
    }

    public RatPoly multiply(Rational val) {
        RatPoly resul = new RatPoly();
        if (val.compareTo(BigInteger.ZERO) != 0) {
            for (int n = 0; n < this.a.size(); ++n) {
                resul.set(n, this.a.elementAt(n).multiply(val));
            }
        }
        return resul;
    }

    public RatPoly multiply(BigInteger val) {
        RatPoly resul = new RatPoly();
        if (val.compareTo(BigInteger.ZERO) != 0) {
            for (int n = 0; n < this.a.size(); ++n) {
                resul.set(n, this.a.elementAt(n).multiply(val));
            }
        }
        return resul;
    }

    public RatPoly multiply(BigIntegerPoly val) {
        return this.multiply(val.toRatPoly());
    }

    public RatPoly multiply(RatPoly val) {
        RatPoly resul = new RatPoly();
        int nmax = this.degree() + val.degree();
        for (int n = 0; n <= nmax; ++n) {
            Rational coef = new Rational(0, 1);
            for (int nleft = 0; nleft <= n; ++nleft) {
                coef = coef.add(this.at(nleft).multiply(val.at(n - nleft)));
            }
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public RatPoly pow(int n) throws ArithmeticException {
        RatPoly resul = new RatPoly("1");
        if (n < 0) {
            throw new ArithmeticException("negative polynomial power " + n);
        }
        for (int i = 1; i <= n; ++i) {
            resul = resul.multiply(this);
        }
        resul.simplify();
        return resul;
    }

    public RatPoly pow(Rational r) throws ArithmeticException {
        Rational f = this.at(0);
        f = f.pow(r);
        RatPoly red = this.divide(this.a.elementAt(0));
        red.set(0, 0);
        RatPoly resul = new RatPoly("1");
        int d = this.degree();
        for (int l = 1; l <= d; ++l) {
            Rational b = Rational.binomial(r, l);
            resul = resul.add(red.pow(l).multiply(b));
        }
        return resul.multiply(f);
    }

    public RatPoly add(RatPoly val) {
        RatPoly resul = new RatPoly();
        int nmax = this.degree() > val.degree() ? this.degree() : val.degree();
        for (int n = 0; n <= nmax; ++n) {
            Rational coef = this.at(n).add(val.at(n));
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public RatPoly subtract(RatPoly val) {
        RatPoly resul = new RatPoly();
        int nmax = this.degree() > val.degree() ? this.degree() : val.degree();
        for (int n = 0; n <= nmax; ++n) {
            Rational coef = this.at(n).subtract(val.at(n));
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public RatPoly divide(Rational val) {
        if (val.compareTo(Rational.ZERO) != 0) {
            RatPoly resul = new RatPoly();
            for (int n = 0; n < this.a.size(); ++n) {
                resul.set(n, this.a.elementAt(n).divide(val));
            }
            return resul;
        }
        throw new ArithmeticException("Cannot divide " + this.toPString() + " through zero.");
    }

    public RatPoly divide(RatPoly val, int nmax) {
        RatPoly num = this;
        RatPoly denom = val;
        while (num.at(0).compareTo(BigInteger.ZERO) == 0 && denom.at(0).compareTo(BigInteger.ZERO) == 0) {
            num.a.remove(0);
            denom.a.remove(0);
            if (num.size() > 1 && denom.size() > 1) continue;
        }
        RatPoly resul = new RatPoly();
        for (int n = 0; n <= nmax; ++n) {
            Rational coef = num.at(n);
            for (int nres = 0; nres < n; ++nres) {
                coef = coef.subtract(resul.at(nres).multiply(denom.at(n - nres)));
            }
            coef = coef.divide(denom.at(0));
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public RatPoly[] divideAndRemainder(RatPoly val) {
        RatPoly[] ret = new RatPoly[2];
        RatPoly valSimpl = val.clone();
        valSimpl.simplify();
        RatPoly thisSimpl = this.clone();
        thisSimpl.simplify();
        if (valSimpl.degree() == 0 && valSimpl.a.firstElement().compareTo(Rational.ZERO) == 0) {
            throw new ArithmeticException("Division through zero polynomial");
        }
        if (thisSimpl.degree() < valSimpl.degree()) {
            ret[0] = new RatPoly();
            ret[1] = thisSimpl;
        } else {
            ret[0] = new RatPoly();
            ret[0].set(thisSimpl.degree() - valSimpl.degree(), thisSimpl.a.lastElement().divide(valSimpl.a.lastElement()));
            ret[1] = thisSimpl.subtract(ret[0].multiply(valSimpl));
            if (ret[1].degree() >= valSimpl.degree()) {
                RatPoly[] rem = ret[1].divideAndRemainder(val);
                ret[0] = ret[0].add(rem[0]);
                ret[1] = rem[1];
            }
        }
        return ret;
    }

    public String toString() {
        Object str = new String();
        for (int n = 0; n < this.a.size(); ++n) {
            str = n == 0 ? (String)str + this.a.elementAt(n).toString() : (String)str + "," + this.a.elementAt(n).toString();
        }
        if (((String)str).length() == 0) {
            str = "0";
        }
        return str;
    }

    public String toPString() {
        Object str = new String();
        for (int n = 0; n < this.a.size(); ++n) {
            BigInteger num = this.a.elementAt((int)n).a;
            if (num.compareTo(BigInteger.ZERO) == 0) continue;
            str = (String)str + " ";
            if (num.compareTo(BigInteger.ZERO) > 0) {
                str = (String)str + "+";
            }
            str = (String)str + this.a.elementAt(n).toString();
            if (n <= 0) continue;
            str = (String)str + "*x";
            if (n <= 1) continue;
            str = (String)str + "^" + n;
        }
        if (((String)str).length() == 0) {
            str = "0";
        }
        return str;
    }

    private void simplify() {
        int n = this.a.size() - 1;
        if (n >= 0) {
            while (this.a.elementAt(n).compareTo(BigInteger.ZERO) == 0) {
                this.a.remove(n);
                if (--n >= 0) continue;
                break;
            }
        }
    }

    public RatPoly derive() {
        if (this.a.size() <= 1) {
            return new RatPoly();
        }
        RatPoly d = new RatPoly();
        for (int i = 1; i <= this.degree(); ++i) {
            Rational c = this.a.elementAt(i).multiply(i);
            d.set(i - 1, c);
        }
        return d;
    }

    public RatPoly monic() {
        RatPoly m = new RatPoly();
        int d = this.degree();
        for (int i = 0; i <= d; ++i) {
            Rational c = this.a.elementAt(i).divide(this.a.elementAt(d));
            m.set(i, c);
        }
        return m;
    }

    public RatPoly mobiusT(int maxdeg) {
        RatPoly r = new RatPoly();
        for (int i = 1; i <= maxdeg; ++i) {
            Rational c = new Rational();
            for (int d = 1; d <= i && d < this.a.size(); ++d) {
                if (i % d != 0) continue;
                Ifactor m = new Ifactor(i / d);
                c = c.add(this.a.elementAt(d).multiply(m.moebius()));
            }
            r.set(i, c);
        }
        r.simplify();
        return r;
    }

    public RatPoly mobiusTInv(int maxdeg) {
        RatPoly r = new RatPoly();
        for (int i = 1; i <= maxdeg; ++i) {
            Rational c = new Rational();
            for (int d = 1; d <= i && d < this.a.size(); ++d) {
                if (i % d != 0) continue;
                c = c.add(this.a.elementAt(d));
            }
            r.set(i, c);
        }
        r.simplify();
        return r;
    }

    public RatPoly binomialT(int maxdeg) {
        RatPoly r = new RatPoly();
        for (int i = 0; i <= maxdeg; ++i) {
            Rational c = new Rational(0, 1);
            for (int j = 0; j <= i && j < this.a.size(); ++j) {
                c = c.add(this.a.elementAt(j).multiply(BigIntegerMath.binomial(i, j)));
            }
            r.set(i, c);
        }
        r.simplify();
        return r;
    }

    public RatPoly binomialTInv(int maxdeg) {
        RatPoly r = new RatPoly();
        for (int i = 0; i <= maxdeg; ++i) {
            Rational c = new Rational(0, 1);
            for (int j = 0; j <= i && j < this.a.size(); ++j) {
                c = (j + i) % 2 != 0 ? c.subtract(this.a.elementAt(j).multiply(BigIntegerMath.binomial(i, j))) : c.add(this.a.elementAt(j).multiply(BigIntegerMath.binomial(i, j)));
            }
            r.set(i, c);
        }
        r.simplify();
        return r;
    }

    public RatPoly trunc(int newdeg) {
        RatPoly t = new RatPoly();
        for (int i = 0; i <= newdeg; ++i) {
            t.set(i, this.at(i));
        }
        t.simplify();
        return t;
    }

    public Vector<BigComplex> roots(int digits) {
        int i;
        RatPoly mon = this.monic();
        Random rand = new Random();
        MathContext mc = new MathContext(digits + 3, RoundingMode.DOWN);
        Vector<BigComplex> res = new Vector<BigComplex>();
        int d = mon.degree();
        double randRad = 0.0;
        for (i = 0; i <= d; ++i) {
            double absi = Math.abs(mon.at(i).doubleValue());
            if (!(absi > randRad)) continue;
            randRad = absi;
        }
        randRad += 1.0;
        for (i = 0; i < d; ++i) {
            double rad = randRad * rand.nextDouble();
            double phi = 6.28318 * rand.nextDouble();
            res.add(i, new BigComplex(rad * Math.cos(phi), rad * Math.sin(phi)));
        }
        boolean convr = false;
        int itr = 0;
        while (!convr) {
            convr = true;
            Vector<BigComplex> resPlus = new Vector<BigComplex>();
            for (int v = 0; v < d; ++v) {
                BigComplex thisx = res.elementAt(v);
                BigComplex nv = mon.valueOf(thisx, mc);
                for (int j = 0; j < d; ++j) {
                    if (j == v) continue;
                    nv = nv.divide(thisx.subtract(res.elementAt(j)), mc);
                }
                if (nv.abs(mc).doubleValue() > thisx.abs(mc).doubleValue() * Math.pow(10.0, -digits)) {
                    convr = false;
                }
                if ((thisx = thisx.subtract(nv)).abs(MathContext.DECIMAL32).doubleValue() > randRad) {
                    return this.roots(digits);
                }
                resPlus.add(thisx);
            }
            res = resPlus;
            ++itr;
        }
        return res;
    }

    public Vector<BigInteger> iroots() {
        Vector<BigInteger> res = new Vector<BigInteger>();
        int lowd = this.ldegree();
        if (lowd == 0 && this.a.elementAt(0).compareTo(BigInteger.ZERO) == 0) {
            res.add(BigInteger.ZERO);
            res.add(BigInteger.ONE);
            return res;
        }
        BigInteger lcmDeno = this.a.elementAt((int)lowd).b;
        for (int i = lowd + 1; i < this.degree(); ++i) {
            lcmDeno = BigIntegerMath.lcm(lcmDeno, this.a.elementAt((int)i).b);
        }
        Vector<BigInteger> ipo = new Vector<BigInteger>();
        for (int i = 0; i < this.a.size(); ++i) {
            BigInteger d = this.a.elementAt((int)i).a.multiply(lcmDeno).divide(this.a.elementAt((int)i).b);
            ipo.add(d);
        }
        BigIntegerPoly p = new BigIntegerPoly(ipo);
        Vector<BigInteger> cand = p.iroots();
        for (int i = 0; i < cand.size(); ++i) {
            BigInteger r = cand.elementAt(i);
            int deg = p.rootDeg(r);
            res.add(r);
            res.add(new BigInteger("" + deg));
        }
        return res;
    }
}

