/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ExceptionUtil;
import ar.com.sdd.commons.util.TxBatchProcessor;
import ar.com.sdd.commons.util.TxBatchProcessorException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TxBatchProcessorHelper
implements TxBatchProcessor {
    public static final long DEFAULT_BATCH_SIZE = 100L;
    private UserTransaction tx;
    private static final Logger log = LogManager.getLogger(TxBatchProcessorHelper.class);
    private long batchSize;
    private long processedItems = 0L;
    private boolean itemsOk = true;
    private boolean inTransaction = false;
    private boolean inIteration = false;
    private boolean handleExceptions = false;
    public static final String USER_TRANSACTION_JNDI = "java:/jboss/UserTransaction";

    public TxBatchProcessorHelper() {
        this.batchSize = 100L;
    }

    public TxBatchProcessorHelper(long batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public boolean getItemsOk() {
        return this.itemsOk;
    }

    @Override
    public void setItemsOk(boolean itemOk) {
        this.itemsOk = itemOk;
    }

    @Override
    public boolean getHandleExceptions() {
        return this.handleExceptions;
    }

    @Override
    public void setHandleExceptions(boolean handleExceptions) {
        this.handleExceptions = handleExceptions;
    }

    @Override
    public boolean endTxBatchIterationIfNeeded() throws TxBatchProcessorException {
        if (!this.inIteration) {
            return false;
        }
        this.endTxBatchIteration();
        return true;
    }

    @Override
    public void beginTxBatchIteration() throws TxBatchProcessorException {
        if (this.inIteration) {
            this.reportTxBatchPatternViolation("beginTxBatchIteration llamado sin llamar al endTxBatchIteration de la iteracion anterior");
        }
        try {
            if (!this.inTransaction) {
                this.tx = (UserTransaction)this.getInitialContext().lookup(USER_TRANSACTION_JNDI);
                int txs = this.tx.getStatus();
                this.tx.begin();
                this.inTransaction = true;
                this.itemsOk = true;
            }
            this.inIteration = true;
        }
        catch (Throwable ex) {
            log.error("problemas al arrancar la Transaccion", ex);
            throw new TxBatchProcessorException(ex);
        }
    }

    @Override
    public boolean endTxBatchIteration() throws TxBatchProcessorException {
        return this.endTxBatchIteration(false);
    }

    @Override
    public boolean endTxBatchIteration(boolean forceCommitOnOk) throws TxBatchProcessorException {
        boolean necesitoReatachear = false;
        if (!this.inIteration) {
            this.reportTxBatchPatternViolation("endTxBatchIteration llamado sin su correspondiente beginTxBatchIteration");
        }
        ++this.processedItems;
        try {
            if (this.itemsOk) {
                if (forceCommitOnOk || this.shouldCommitTransaction()) {
                    this.commitTransaction();
                    necesitoReatachear = true;
                }
            } else {
                this.rollbackTransaction();
                necesitoReatachear = true;
            }
        }
        finally {
            this.inIteration = false;
        }
        return necesitoReatachear;
    }

    @Override
    public void endTxBatchProcess() throws TxBatchProcessorException {
        if (this.inIteration) {
            this.reportTxBatchPatternViolation("endTxBatchProcess llamado sin llamar al endTxBatchIteration de la iteracion anterior");
            this.endTxBatchIteration();
        }
        if (this.inActiveTransaction()) {
            this.commitTransaction();
        }
    }

    private void commitTransaction() throws TxBatchProcessorException {
        try {
            if (this.inActiveTransaction()) {
                this.tx.commit();
            }
        }
        catch (Exception ex) {
            log.error("Problemas al comitear la transaccion", (Throwable)ex);
            this.rollbackTransaction();
            if (!this.handleExceptions) {
                throw new TxBatchProcessorException("Problemas al realizar el commit de la transaccion", ex);
            }
        }
        finally {
            this.processedItems = 0L;
            this.inTransaction = false;
            this.inIteration = false;
            this.itemsOk = true;
        }
    }

    @Override
    public void exceptionalCommit() throws TxBatchProcessorException {
        block3: {
            log.debug("EJECUTANDO COMMIT EN FORMA EXCEPCIONAL");
            try {
                if (this.inActiveTransaction()) {
                    this.tx.commit();
                }
            }
            catch (Exception ex) {
                log.error("Problemas al comitear la transaccion", (Throwable)ex);
                this.rollbackTransaction();
                if (this.handleExceptions) break block3;
                throw new TxBatchProcessorException("Problemas al realizar el commit de la transaccion", ex);
            }
        }
    }

    private void rollbackTransaction() throws TxBatchProcessorException {
        try {
            if (this.inActiveTransaction()) {
                this.tx.rollback();
            }
            log.error("Se hizo rollback de la transaccion, podrian no haberse procesado " + this.processedItems + " elementos. El batchSize es de: " + this.batchSize + " elementos");
        }
        catch (Exception ex) {
            log.error("Problemas al hacer rollback de la transaccion, podrian no haberse procesado " + this.processedItems + " elementos. El batchSize es de: " + this.batchSize + " elementos", (Throwable)ex);
            if (!this.handleExceptions) {
                throw new TxBatchProcessorException("Problemas al realizar el rollback de la transaccion", ex);
            }
        }
        finally {
            this.processedItems = 0L;
            this.inTransaction = false;
            this.inIteration = false;
            this.itemsOk = true;
        }
    }

    private void reportTxBatchPatternViolation(String mensaje) {
        log.error(mensaje);
        log.error(ExceptionUtil.dumpStackTace());
    }

    private InitialContext getInitialContext() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex) {
            log.error("Problemas al obtener el contexto JNDI", (Throwable)ex);
        }
        return ctx;
    }

    private boolean shouldCommitTransaction() {
        return this.processedItems % this.batchSize == 0L;
    }

    private boolean inActiveTransaction() throws TxBatchProcessorException {
        try {
            return this.inTransaction && this.tx != null && this.tx.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new TxBatchProcessorException(e);
        }
    }

    public static boolean checkIfAlreadyInsideAnActiveTransaction() {
        boolean alreadyInActiveTransaction = false;
        try {
            UserTransaction actualTransaction = (UserTransaction)new InitialContext().lookup(USER_TRANSACTION_JNDI);
            alreadyInActiveTransaction = actualTransaction != null && actualTransaction.getStatus() == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alreadyInActiveTransaction;
    }
}

