/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.converter;

import ar.com.sdd.commons.util.SynchronizedSimpleDateFormat;
import ar.com.sdd.commons.util.converter.DataConverter;
import java.text.ParseException;
import java.util.Date;

public class StringToDateConverter
implements DataConverter {
    private static StringToDateConverter instance = null;
    private static final SynchronizedSimpleDateFormat formatter = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
    private static final SynchronizedSimpleDateFormat alternateFormatter = new SynchronizedSimpleDateFormat("yyyy-MM-dd");

    protected static StringToDateConverter getInstance() {
        if (instance == null) {
            instance = new StringToDateConverter();
        }
        return instance;
    }

    public static Date convertTo(String o) {
        return (Date)StringToDateConverter.getInstance().convertDataTo(o);
    }

    public static String convertFrom(Date o) {
        String dateStr = (String)StringToDateConverter.getInstance().convertFromData(o);
        return dateStr != null ? dateStr : "";
    }

    @Override
    public Object convertDataTo(Object o) {
        if (o == null || ((String)o).equals("") || ((String)o).equals("null")) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("El objeto no es String");
        }
        Date fecha = null;
        try {
            fecha = formatter.parse((String)o);
        }
        catch (ParseException ex) {
            try {
                fecha = alternateFormatter.parse((String)o);
            }
            catch (ParseException ex2) {
                throw new IllegalArgumentException("Formato del string invalido: [" + ex.getMessage() + "]");
            }
        }
        return fecha;
    }

    @Override
    public Object convertFromData(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Date)) {
            throw new IllegalArgumentException("El objeto a convertir no es Date: [" + o + "]");
        }
        Date fecha = (Date)o;
        return formatter.format(fecha);
    }
}

