package ar.com.sdd.commons.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.xml.bind.DatatypeConverter;
import java.io.*;
import java.security.*;
import java.security.cert.Certificate;
 
class KeyExporter {
	
	private static Logger log = LogManager.getLogger(KeyExporter.class);
	
    public static void main(String args[]) throws Exception{
    	String alias = "tomcat";
    	String passPhrase = "keyadmin";
    	String fileName = args[ 0 ];
    	String outKeyFileName = args.length > 1? args[ 1 ]: null;
    	String outCertFileName = args.length > 2? args[ 2 ]: null;
    	KeyExporter myep = new KeyExporter();
    	if ( outKeyFileName == null ) {
	    	File file = new File ( fileName );
	    	String baseName = file.getName();
	    	if ( baseName.endsWith( ".jks" ) || baseName.endsWith( ".keystore" ) )
	    		baseName = baseName.substring( 0, baseName.lastIndexOf( '.' ) );
	    	outKeyFileName = (new File( file.getParentFile(), baseName + ".key.pem" )).getAbsolutePath();
    	}
    	if ( outCertFileName == null ) {
	    	File file = new File ( outKeyFileName );
	    	String baseName = file.getName();
	    	if ( baseName.endsWith( ".key.pem" ) )
	    		baseName = baseName.substring( 0, baseName.lastIndexOf( '.' , baseName.lastIndexOf( '.' ) - 1 ) );
	    	outCertFileName = (new File( file.getParentFile(), baseName + ".cert.pem" )).getAbsolutePath();
    	}
    	
    	myep.doit( alias, passPhrase, fileName, outKeyFileName, outCertFileName );
    }
 
    public void doit( String alias, String passphrase, String fileName, String outKeyFileName, String outCertFileName ) throws Exception{
 
	KeyStore ks = KeyStore.getInstance("JKS");
 
	char[] passPhrase = passphrase.toCharArray();
	
 
	File certificateFile = new File(fileName);
	ks.load(new FileInputStream(certificateFile), passPhrase);
 
	// Exportar clave privada
	KeyPair kp = getPrivateKey(ks, alias, passPhrase);
	
	PrivateKey privKey = kp.getPrivate();
	
	//BASE64Encoder myB64 = new BASE64Encoder();
	//String b64 = myB64.encode(privKey.getEncoded());
	String b64 = DatatypeConverter.printBase64Binary(privKey.getEncoded());
	
	
	
	File outFile = new File( outKeyFileName );
	if ( outFile.canRead() )
		throw new Exception( outKeyFileName + " ya existe. Borrarlo si se quiere reemplazar" );
	PrintStream ps = new PrintStream( new BufferedOutputStream(new FileOutputStream( outFile ) ));
 
	ps.println("-----BEGIN PRIVATE KEY-----");
	ps.println(b64);
	ps.println("-----END PRIVATE KEY-----");
	ps.close();
 
	// Exportar certificado
	Certificate cert = getCertificate(ks, alias, passPhrase);
	
	//b64 = myB64.encode(cert.getEncoded());
	b64 = DatatypeConverter.printBase64Binary(cert.getEncoded());
	
	outFile = new File( outCertFileName );
	if ( outFile.canRead() )
		throw new Exception( outCertFileName + " ya existe. Borrarlo si se quiere reemplazar" );
	ps = new PrintStream( new BufferedOutputStream(new FileOutputStream( outFile ) ));
 
	ps.println("-----BEGIN CERTIFICATE-----");
	ps.println(b64);
	ps.println("-----END CERTIFICATE-----");
	ps.close();
 
	}
 
// From http://javaalmanac.com/egs/java.security/GetKeyFromKs.html
 
   public KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            // Get private key
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                // Get certificate of public key
                Certificate cert = keystore.getCertificate(alias);
    
                // Get public key
                PublicKey publicKey = cert.getPublicKey();
    
                // Return a key pair
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        } catch (UnrecoverableKeyException e) {
        	log.error("Ha ocurrido un error", e);
        } catch (NoSuchAlgorithmException e) {
        	log.error("Ha ocurrido un error", e);
        } catch (KeyStoreException e) {
        	log.error("Ha ocurrido un error", e);
        }
        return null;
    }
   
   public Certificate getCertificate(KeyStore keystore, String alias, char[] password) {
       try {
           // Get private key
           Key key = keystore.getKey(alias, password);
           if (key instanceof PrivateKey) {
               // Get certificate of public key
               Certificate cert = keystore.getCertificate(alias);
               return cert;
           }
       } catch (UnrecoverableKeyException e) {
    	   log.error("Ha ocurrido un error", e);
       } catch (NoSuchAlgorithmException e) {
    	   log.error("Ha ocurrido un error", e);
       } catch (KeyStoreException e) {
    	   log.error("Ha ocurrido un error", e);
       }
       return null;
   }
 
}