package ar.com.sdd.commons.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * SynchronizedSimpleDateFormat
 * Esta clase esta pensada para reemplazar los usos de SimpleDateFormat
 * donde se requiera que las llamadas a los metodos parse y format
 * sean sincronizadas; en UNL-315 y EBF-233 los errores se debian
 * a que desde distintos threads se llamaba a metodos del mismo objeto
 * SimpleDateFormat (puesto como static de una clase) y se devolvian
 * resultados erroneos.
 * @author malbanesi
 * @since 06/11/2006
 */
public class SynchronizedSimpleDateFormat {

	private SimpleDateFormat sdf = null;

	// Constructores

	public SynchronizedSimpleDateFormat() {
		sdf = new SimpleDateFormat();
	}

	public SynchronizedSimpleDateFormat(String pattern) {
		sdf = new SimpleDateFormat(pattern);
	}

	public SynchronizedSimpleDateFormat(String pattern,
                                        DateFormatSymbols formatSymbols) {
		sdf = new SimpleDateFormat(pattern, formatSymbols);
	}

	public SynchronizedSimpleDateFormat(String pattern, Locale locale) {
		sdf = new SimpleDateFormat(pattern, locale);
	}


	/**
	 * Misma interfase que el SimpleDateFormat.format(Date date)
	 * Al marcarlo como synchronized se hace thread-safe a format(Date) 
	 */
	public synchronized final String format(Date date) {
		return date==null?null:sdf.format(date);
	}

	/**
	 * Misma interfase que SimpleDateFormat.parse(String source)
	 * Al marcarlo como synchronized se lo hace thread-safe 
	 */
    public synchronized final Date parse(String source) throws ParseException {
        if (source == null) return null;
        return sdf.parse(source);
    }
	// Otros metodos de la interfase SimpleDateFormat o de DateFormat o de Format

//	public synchronized Object parseObject(String source, ParsePosition pos) {
//		return sdf.parseObject(source, pos);
//	}

//	public synchronized Date parse(String source, ParsePosition pos) {
//		return sdf.parse(source, pos);
//	}

//	public synchronized StringBuilder format(Object obj, StringBuilder toAppendTo, FieldPosition pos) {
//		return sdf.format(obj, toAppendTo, pos);
//	}

//	public synchronized StringBuilder format(Date date, StringBuilder toAppendTo, FieldPosition fieldPosition) {
//		return sdf.format(date, toAppendTo, fieldPosition);
//	}

	public String toString() {
		return "SynchronizedSimpleDateFormat(" + sdf.toString() + ")";
	}

}
