package ar.com.sdd.commons.util.converter;


import ar.com.sdd.commons.util.StringUtil;

import java.util.Date;

/**
 * Conversor entre campos del JSP y Strings Java.
 */
public class JspFieldToStringConverter implements DataConverter {

	static JspFieldToStringConverter instancia = null;

	
	//---------------------------------------------------------------------------//

	public JspFieldToStringConverter() {}
	
	protected static JspFieldToStringConverter getInstance() {
		if (instancia == null) instancia = new JspFieldToStringConverter();
		return instancia;
	}
	
	public static String convertTo(String o) {
		return (String)getInstance().convertDataTo(o);
	}
	
	public static String convertFrom(Object o) {
		return (String)getInstance().convertFromData(o);
	}
	
	public static String convertFrom(int i) {
		return (String)getInstance().convertFromData(Integer.valueOf(i));
	}
	
	public static String convertFrom(long l) {
		return (String)getInstance().convertFromData(Long.valueOf(l));
	}
	
	public static String convertFrom(char c) {
		return (String)getInstance().convertFromData(Character.valueOf(c));
	}
	
	public static String convertFrom(float f) {
		return (String)getInstance().convertFromData(Float.valueOf(f));
	}
	
	public static String convertFrom(double d) {
		return (String)getInstance().convertFromData(Double.valueOf(d));
	}
	
	public static String convertFrom(byte b) {
		return (String)getInstance().convertFromData(Byte.valueOf(b));
	}
	
	public static String convertFrom(boolean b) {
		return (String)getInstance().convertFromData(Boolean.valueOf(b));
	}


	/**
	 * Recibe un string con el contenido de un campo de un formulario JSP. El string
	 * se procesa para sacar espacios adelante y atras. Ademas convierte a la cadena vacia
	 * y la cadena "null" en un String <b>null</b>.
	 */
	public Object convertDataTo(Object o) {
		
		String jspValue = (String) o;
		
		if (jspValue != null) {
			
		    jspValue = jspValue.trim();
		    if (jspValue.length() == 0 || jspValue.equals("null")) {
				jspValue = null;
		    }
		    
		}
		
		return jspValue;
	}
		
		
	/**
	 * Recibe un string que contiene el valor del campo. Si contiene espacios
	 * adelante o atras, se remueven. Si el string es <b>null</b> o tiene el
	 * valor "null", se lo convierte en "&nbsp;".
	 */
	public Object convertFromData(Object o) {
		String value = "";
		if (o != null) {
			if (o instanceof Date) {
				value = StringToDateConverter.convertFrom((Date)o);
			} else if (o instanceof Double) {
				value = StringToDoubleConverter.convertFrom((Double)o);
			} else {
				value = o.toString().trim();
			}
			
			if (StringUtil.isEmptyNull(value)) value = "";
		}
		
		return value;
	}
    
	public static String convertHideZeroDecimalsFrom(double d) {
		String ret = convertFrom(d);
		if (ret.endsWith(".00"))
			ret = ret.substring(0, ret.length()-3); // sacar el .00
		if (ret.endsWith(".0"))
			ret = ret.substring(0, ret.length()-2); // sacar el .0
		return ret;
	}
	
}