package ar.com.sdd.commons.util.converter;

import java.util.StringTokenizer;


/**
 * Convierte un string que posiblemente empiece en minuscula o tenga subcadenas
 * separadas por "-" en el nombre de un metodo siguiendo la convencion Java:
 * cada palabra empieza en mayuscula y continua en minuscula, excepto la primera,
 * que queda toda en minuscula.
 * <p>
 * Por ejemplo:<br>
 * <b>get-name</b> se convierte en <b>getName</b> <br>
 * <b>run</b>  se convierte en <b>run</b>  (no cambia) <br>
 * <b>iNIT</b>  se convierte en <b>init</b> <br>
 */
public class StringToMethodNameConverter implements DataConverter {


   static StringToMethodNameConverter instancia = null;

   public StringToMethodNameConverter() {}

   protected static StringToMethodNameConverter getInstance() {
      if (instancia == null) {
         instancia = new StringToMethodNameConverter();
      }
      return instancia;
   }

   public static String convertTo(String o) {
      return (String)getInstance().convertDataTo(o);
   }

   public static String convertFrom(String o) {
      return (String)getInstance().convertFromData(o);
   }

    /**
    */
    public Object convertDataTo(Object o) {
        String text = (String)o;
        StringTokenizer st = new StringTokenizer(text, "-");
        StringBuilder buffer = new StringBuilder(text.length());


        if (st.hasMoreTokens()) {
            //el primer token va todo en minuscula
            buffer.append(st.nextToken().toLowerCase());
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            buffer.append(token.substring(0,1).toUpperCase()).append(token.substring(1).toLowerCase());
        }

        return buffer.toString();
   }


   /**
    */
    public Object convertFromData(Object o) {
        return o;
    }
}