package ar.com.sdd.commons.util.converter;

/**
 * Convierte Strings en Strings (aunque no parece demasiado interesante), pero
 * teniedo en cuenta que si en ambos sentidos de conversion, si el objeto de
 * origen es null, el objeto convertido sera null, pero si el origen era distinto
 * de null, entonces el destino sera la misma cadena pero sin espacios al
 * principio ni al final.
 *
 * Company:      SDD
 * @author AA
 * @version 1.0
 */
public class StringTrimmerConverter implements DataConverter {


   static StringTrimmerConverter instancia = null;

   public StringTrimmerConverter() {}

   protected static StringTrimmerConverter getInstance() {
      if (instancia == null) {
         instancia = new StringTrimmerConverter();
      }
      return instancia;
   }

   public static String convertTo(String o) {
      return (String)getInstance().convertDataTo(o);
   }

   public Object convertDataTo(Object o) {
        String source = (String)o;
        return source != null ? source.trim() : null;
   }

   public Object convertFromData(Object o) {
        return convertDataTo(o);
   }

}