/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.InitializationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class GenericFactory {
    public static Object create(String className, Properties args) throws InitializationException {
        if (className == null) {
            throw new InitializationException("Nombre de la clase a instanciar nulo.");
        }
        try {
            Class<?> objectClass = Class.forName(className);
            Object newObject = objectClass.newInstance();
            Method initMethod = objectClass.getMethod("init", Properties.class);
            initMethod.invoke(newObject, args);
            return newObject;
        }
        catch (ClassNotFoundException ex) {
            throw new InitializationException("No se encuentra la clase [" + className + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InitializationException("No se puede acceder a los metodos de la clase [" + className + "]", ex);
        }
        catch (InstantiationException ex) {
            throw new InitializationException("No se puede instanciar la clase [" + className + "]", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InitializationException("No se existe el metodo [init] en la clase [" + className + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InitializationException("Error al inicializar objeto de la clase [" + className + "]", ex.getTargetException());
        }
    }
}

