/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class KeyExporter {
    private static Logger log = LogManager.getLogger(KeyExporter.class);

    KeyExporter() {
    }

    public static void main(String[] args) throws Exception {
        String baseName;
        File file;
        String alias = "tomcat";
        String passPhrase = "keyadmin";
        String fileName = args[0];
        String outKeyFileName = args.length > 1 ? args[1] : null;
        String outCertFileName = args.length > 2 ? args[2] : null;
        KeyExporter myep = new KeyExporter();
        if (outKeyFileName == null) {
            file = new File(fileName);
            baseName = file.getName();
            if (baseName.endsWith(".jks") || baseName.endsWith(".keystore")) {
                baseName = baseName.substring(0, baseName.lastIndexOf(46));
            }
            outKeyFileName = new File(file.getParentFile(), baseName + ".key.pem").getAbsolutePath();
        }
        if (outCertFileName == null) {
            file = new File(outKeyFileName);
            baseName = file.getName();
            if (baseName.endsWith(".key.pem")) {
                baseName = baseName.substring(0, baseName.lastIndexOf(46, baseName.lastIndexOf(46) - 1));
            }
            outCertFileName = new File(file.getParentFile(), baseName + ".cert.pem").getAbsolutePath();
        }
        myep.doit(alias, passPhrase, fileName, outKeyFileName, outCertFileName);
    }

    public void doit(String alias, String passphrase, String fileName, String outKeyFileName, String outCertFileName) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] passPhrase = passphrase.toCharArray();
        File certificateFile = new File(fileName);
        ks.load(new FileInputStream(certificateFile), passPhrase);
        KeyPair kp = this.getPrivateKey(ks, alias, passPhrase);
        PrivateKey privKey = kp.getPrivate();
        String b64 = DatatypeConverter.printBase64Binary((byte[])privKey.getEncoded());
        File outFile = new File(outKeyFileName);
        if (outFile.canRead()) {
            throw new Exception(outKeyFileName + " ya existe. Borrarlo si se quiere reemplazar");
        }
        PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        ps.println("-----BEGIN PRIVATE KEY-----");
        ps.println(b64);
        ps.println("-----END PRIVATE KEY-----");
        ps.close();
        Certificate cert = this.getCertificate(ks, alias, passPhrase);
        b64 = DatatypeConverter.printBase64Binary((byte[])cert.getEncoded());
        outFile = new File(outCertFileName);
        if (outFile.canRead()) {
            throw new Exception(outCertFileName + " ya existe. Borrarlo si se quiere reemplazar");
        }
        ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        ps.println("-----BEGIN CERTIFICATE-----");
        ps.println(b64);
        ps.println("-----END CERTIFICATE-----");
        ps.close();
    }

    public KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (UnrecoverableKeyException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return null;
    }

    public Certificate getCertificate(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                return cert;
            }
        }
        catch (UnrecoverableKeyException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return null;
    }
}

