/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.Factorial;
import ar.com.sdd.commons.util.math.Ifactor;
import ar.com.sdd.commons.util.math.Rational;
import java.math.BigInteger;
import java.util.Vector;

public class BigIntegerMath {
    public static BigInteger binomial(int n, int k) {
        BigInteger bin;
        if (k == 0) {
            return BigInteger.ONE;
        }
        BigInteger n2 = bin = BigInteger.valueOf(n);
        BigInteger i = BigInteger.valueOf(k - 1);
        while (i.compareTo(BigInteger.ONE) >= 0) {
            bin = bin.multiply(n2.subtract(i));
            i = i.subtract(BigInteger.ONE);
        }
        i = BigInteger.valueOf(k);
        while (i.compareTo(BigInteger.ONE) == 1) {
            bin = bin.divide(i);
            i = i.subtract(BigInteger.ONE);
        }
        return bin;
    }

    public static BigInteger binomial(BigInteger n, BigInteger k) {
        if (k.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ONE;
        }
        BigInteger bin = n;
        BigInteger truek = k;
        if (n.subtract(k).compareTo(k) < 0) {
            truek = n.subtract(k);
        }
        BigInteger i = BigInteger.valueOf(2L);
        BigInteger num = n;
        while (i.compareTo(truek) <= 0) {
            num = num.subtract(BigInteger.ONE);
            bin = bin.multiply(num).divide(i);
            i = i.add(BigInteger.ONE);
        }
        return bin;
    }

    public static BigInteger sigmak(BigInteger n, int k) {
        return new Ifactor((BigInteger)n.abs()).sigma((int)k).n;
    }

    public static BigInteger sigma(int n) {
        return new Ifactor((int)Math.abs((int)n)).sigma().n;
    }

    public static Vector<BigInteger> divisors(BigInteger n) {
        return new Ifactor(n.abs()).divisors();
    }

    public static BigInteger sigma(BigInteger n) {
        return new Ifactor((BigInteger)n.abs()).sigma().n;
    }

    public BigInteger eulerPhi(int n) {
        return this.eulerPhi(BigInteger.valueOf(n));
    }

    public BigInteger eulerPhi(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("negative argument " + n + " of EulerPhi");
        }
        Ifactor prFact = new Ifactor(n);
        BigInteger phi = n;
        if (n.compareTo(BigInteger.ONE) > 0) {
            for (int i = 0; i < prFact.primeexp.size(); i += 2) {
                BigInteger p = new BigInteger(prFact.primeexp.elementAt(i).toString());
                BigInteger p_1 = p.subtract(BigInteger.ONE);
                phi = phi.multiply(p_1).divide(p);
            }
        }
        return phi;
    }

    public static int isqrt(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative argument " + n);
        }
        double resul = Math.sqrt(n);
        return (int)Math.round(resul);
    }

    public static long isqrt(long n) {
        if (n < 0L) {
            throw new ArithmeticException("Negative argument " + n);
        }
        double resul = Math.sqrt(n);
        return Math.round(resul);
    }

    public static BigInteger isqrt(BigInteger n) {
        BigInteger x;
        if (n.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Negative argument " + n.toString());
        }
        int bl = n.bitLength();
        if (bl > 120) {
            x = n.shiftRight(bl / 2 - 1);
        } else {
            double resul = Math.sqrt(n.doubleValue());
            x = new BigInteger("" + Math.round(resul));
        }
        BigInteger two = BigInteger.valueOf(2L);
        while (true) {
            BigInteger x2 = x.pow(2);
            BigInteger xplus2 = x.add(BigInteger.ONE).pow(2);
            if (x2.compareTo(n) <= 0 && xplus2.compareTo(n) > 0) {
                return x;
            }
            if ((xplus2 = xplus2.subtract(x.shiftLeft(2))).compareTo(n) <= 0 && x2.compareTo(n) > 0) {
                return x.subtract(BigInteger.ONE);
            }
            xplus2 = x2.subtract(n).divide(x).divide(two);
            x = x.subtract(xplus2);
        }
    }

    public static BigInteger iroot(BigInteger x, int n) {
        BigInteger r;
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Negative argument " + x.toString());
        }
        if (n < 1) {
            throw new ArithmeticException("Non-positive argument " + n);
        }
        BigInteger nBig = BigInteger.valueOf(n);
        int bl = x.bitLength();
        if (bl > 120) {
            r = x.shiftRight(bl / n - 1);
        } else {
            double resul = Math.pow(x.doubleValue(), 1.0 / (double)n);
            r = new BigInteger("" + Math.round(resul));
        }
        while (true) {
            BigInteger r2 = r.pow(n);
            BigInteger rplus2 = r.add(BigInteger.ONE).pow(n);
            if (r2.compareTo(x) <= 0 && rplus2.compareTo(x) > 0) {
                return r;
            }
            rplus2 = r.subtract(BigInteger.ONE).pow(n);
            if (rplus2.compareTo(x) <= 0 && r2.compareTo(x) > 0) {
                return r.subtract(BigInteger.ONE);
            }
            rplus2 = r2.subtract(x).divide(r.pow(n - 1)).divide(nBig);
            r = r.subtract(rplus2);
        }
    }

    public static BigInteger core(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Negative argument " + n);
        }
        Ifactor i = new Ifactor(n);
        return i.core();
    }

    public static BigInteger[][] minor(BigInteger[][] A, int r, int c) throws ArithmeticException {
        int rL = A.length;
        if (rL == 0) {
            throw new ArithmeticException("zero row count in matrix");
        }
        if (r < 0 || r >= rL) {
            throw new ArithmeticException("row number " + r + " out of range 0.." + (rL - 1));
        }
        int cL = A[0].length;
        if (cL == 0) {
            throw new ArithmeticException("zero column count in matrix");
        }
        if (c < 0 || c >= cL) {
            throw new ArithmeticException("column number " + c + " out of range 0.." + (cL - 1));
        }
        BigInteger[][] M = new BigInteger[rL - 1][cL - 1];
        int imrow = 0;
        for (int row = 0; row < rL; ++row) {
            if (row == r) continue;
            int imcol = 0;
            for (int col = 0; col < cL; ++col) {
                if (col == c) continue;
                M[imrow][imcol] = A[row][col];
                ++imcol;
            }
            ++imrow;
        }
        return M;
    }

    private static BigInteger[][] colSubs(BigInteger[][] A, int c, BigInteger[] v) throws ArithmeticException {
        int rL = A.length;
        if (rL == 0) {
            throw new ArithmeticException("zero row count in matrix");
        }
        int cL = A[0].length;
        if (cL == 0) {
            throw new ArithmeticException("zero column count in matrix");
        }
        if (c < 0 || c >= cL) {
            throw new ArithmeticException("column number " + c + " out of range 0.." + (cL - 1));
        }
        BigInteger[][] M = new BigInteger[rL][cL];
        for (int row = 0; row < rL; ++row) {
            for (int col = 0; col < cL; ++col) {
                M[row][col] = col != c ? A[row][col] : v[row];
            }
        }
        return M;
    }

    public static BigInteger det(BigInteger[][] A) throws ArithmeticException {
        BigInteger d = BigInteger.ZERO;
        int rL = A.length;
        if (rL == 0) {
            throw new ArithmeticException("zero row count in matrix");
        }
        int cL = A[0].length;
        if (cL != rL) {
            throw new ArithmeticException("Non-square matrix dim " + rL + " by " + cL);
        }
        if (rL == 1) {
            return A[0][0];
        }
        if (rL == 2) {
            d = A[0][0].multiply(A[1][1]);
            return d.subtract(A[0][1].multiply(A[1][0]));
        }
        for (int r = 0; r < rL; ++r) {
            if (A[r][0].compareTo(BigInteger.ZERO) == 0) continue;
            BigInteger[][] M = BigIntegerMath.minor(A, r, 0);
            BigInteger m = A[r][0].multiply(BigIntegerMath.det(M));
            d = r % 2 == 0 ? d.add(m) : d.subtract(m);
        }
        return d;
    }

    public static Rational[] solve(BigInteger[][] A, BigInteger[] rhs) throws ArithmeticException {
        int c;
        int rL = A.length;
        if (rL == 0) {
            throw new ArithmeticException("zero row count in matrix");
        }
        int cL = A[0].length;
        if (cL != rL) {
            throw new ArithmeticException("Non-square matrix dim " + rL + " by " + cL);
        }
        if (rhs.length != rL) {
            throw new ArithmeticException("Right hand side dim " + rhs.length + " unequal matrix dim " + rL);
        }
        Rational[] x = new Rational[rL];
        for (c = 0; c < cL; ++c) {
            x[c] = new Rational(rhs[c]);
        }
        for (c = 0; c < cL - 1; ++c) {
            Comparable<Rational> tmp;
            if (A[c][c].compareTo(BigInteger.ZERO) == 0) {
                boolean swpd = false;
                for (int r = c + 1; r < rL; ++r) {
                    if (A[r][c].compareTo(BigInteger.ZERO) == 0) continue;
                    for (int cpr = c; cpr < cL; ++cpr) {
                        BigInteger tmp2 = A[c][cpr];
                        A[c][cpr] = A[r][cpr];
                        A[r][cpr] = tmp2;
                    }
                    tmp = x[c];
                    x[c] = x[r];
                    x[r] = tmp;
                    swpd = true;
                    break;
                }
                if (!swpd) {
                    throw new ArithmeticException("Zero determinant of main matrix");
                }
            }
            for (int r = c + 1; r < rL; ++r) {
                Rational tmp3;
                for (int cpr = c + 1; cpr < cL; ++cpr) {
                    tmp = A[c][c].multiply(A[r][cpr]).subtract(A[c][cpr].multiply(A[r][c]));
                    A[r][cpr] = tmp;
                }
                x[r] = tmp3 = x[r].multiply(A[c][c]).subtract(x[c].multiply(A[r][c]));
            }
        }
        if (A[cL - 1][cL - 1].compareTo(BigInteger.ZERO) == 0) {
            throw new ArithmeticException("Zero determinant of main matrix");
        }
        for (int r = cL - 1; r >= 0; --r) {
            x[r] = x[r].divide(A[r][r]);
            for (int rpr = r - 1; rpr >= 0; --rpr) {
                x[rpr] = x[rpr].subtract(x[r].multiply(A[rpr][r]));
            }
        }
        return x;
    }

    public static BigInteger lcm(BigInteger a, BigInteger b) {
        BigInteger g = a.gcd(b);
        return a.multiply(b).abs().divide(g);
    }

    public static BigInteger valueOf(Vector<BigInteger> c, BigInteger x) {
        if (c.size() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger res = c.lastElement();
        for (int i = c.size() - 2; i >= 0; --i) {
            res = res.multiply(x).add(c.elementAt(i));
        }
        return res;
    }

    public static Rational centrlFactNumt(int n, int k) {
        if (k > n || k < 0 || k % 2 != n % 2) {
            return Rational.ZERO;
        }
        if (k == n) {
            return Rational.ONE;
        }
        Factorial f = new Factorial();
        Rational jsum = new Rational(0, 1);
        int kprime = n - k;
        for (int j = 0; j <= kprime; ++j) {
            Rational nusum = new Rational(0, 1);
            for (int nu = 0; nu <= j; ++nu) {
                Rational t = new Rational(j - 2 * nu, 2);
                t = t.pow(kprime + j);
                t = t.multiply(BigIntegerMath.binomial(j, nu));
                nusum = nu % 2 != 0 ? nusum.subtract(t) : nusum.add(t);
            }
            nusum = nusum.divide(f.at(j)).divide(n + j);
            nusum = nusum.multiply(BigIntegerMath.binomial(2 * kprime, kprime - j));
            jsum = j % 2 != 0 ? jsum.subtract(nusum) : jsum.add(nusum);
        }
        return jsum.multiply(k).multiply(BigIntegerMath.binomial(n + kprime, k));
    }

    public static Rational centrlFactNumT(int n, int k) {
        if (k > n || k < 0 || k % 2 != n % 2) {
            return Rational.ZERO;
        }
        if (k == n) {
            return Rational.ONE;
        }
        return BigIntegerMath.centrlFactNumT(n - 2, k - 2).add(BigIntegerMath.centrlFactNumT(n - 2, k).multiply(new Rational(k * k, 4)));
    }
}

