/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigComplex;
import ar.com.sdd.commons.util.math.BigDecimalMath;
import ar.com.sdd.commons.util.math.BigIntegerMath;
import ar.com.sdd.commons.util.math.RatPoly;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Scanner;
import java.util.Vector;

public class BigIntegerPoly
implements Cloneable {
    Vector<BigInteger> a;
    public static final BigIntegerPoly ONE = new BigIntegerPoly("1");
    public static final BigIntegerPoly X = new BigIntegerPoly("0,1");

    public BigIntegerPoly() {
        this.a = new Vector();
    }

    public BigIntegerPoly(String L) throws NumberFormatException {
        this.a = new Vector();
        Scanner sc = new Scanner(L);
        sc.useDelimiter(",");
        while (sc.hasNextBigInteger()) {
            this.a.add(sc.nextBigInteger());
        }
        this.simplify();
    }

    public BigIntegerPoly(Vector<BigInteger> c) {
        this.a = (Vector)c.clone();
        this.simplify();
    }

    public BigIntegerPoly(BigInteger[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.a.add(c[i].add(BigInteger.ZERO));
        }
        this.simplify();
    }

    public BigIntegerPoly clone() {
        return new BigIntegerPoly(this.a);
    }

    public RatPoly toRatPoly() {
        RatPoly bd = new RatPoly();
        for (int i = 0; i < this.a.size(); ++i) {
            bd.set(i, this.a.elementAt(i));
        }
        return bd;
    }

    public BigInteger at(int n) {
        if (n < this.a.size()) {
            return this.a.elementAt(n);
        }
        return BigInteger.ZERO;
    }

    public BigInteger valueOf(BigInteger x) {
        if (this.a.size() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger res = this.a.lastElement();
        for (int i = this.a.size() - 2; i >= 0; --i) {
            res = res.multiply(x).add(this.a.elementAt(i));
        }
        return res;
    }

    public BigInteger valueOf(int x) {
        return this.valueOf(new BigInteger("" + x));
    }

    public void set(int n, BigInteger value) {
        if (n < this.a.size()) {
            this.a.set(n, value);
        } else {
            while (this.a.size() < n) {
                this.a.add(BigInteger.ZERO);
            }
            this.a.add(value);
        }
    }

    public void set(int n, int value) {
        BigInteger val2 = new BigInteger("" + value);
        this.set(n, val2);
    }

    public int size() {
        return this.a.size();
    }

    public int degree() {
        return this.a.size() - 1;
    }

    public int ldegree() {
        for (int n = 0; n < this.a.size(); ++n) {
            if (this.a.elementAt(n).compareTo(BigInteger.ZERO) == 0) continue;
            return n;
        }
        return 0;
    }

    public BigIntegerPoly multiply(BigInteger val) {
        BigIntegerPoly resul = new BigIntegerPoly();
        if (val.compareTo(BigInteger.ZERO) != 0) {
            for (int n = 0; n < this.a.size(); ++n) {
                resul.set(n, this.a.elementAt(n).multiply(val));
            }
        }
        return resul;
    }

    public BigIntegerPoly multiply(BigIntegerPoly val) {
        BigIntegerPoly resul = new BigIntegerPoly();
        int nmax = this.degree() + val.degree();
        for (int n = 0; n <= nmax; ++n) {
            BigInteger coef = BigInteger.ZERO;
            for (int nleft = 0; nleft <= n; ++nleft) {
                coef = coef.add(this.at(nleft).multiply(val.at(n - nleft)));
            }
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public BigIntegerPoly pow(int n) throws ArithmeticException {
        BigIntegerPoly resul = new BigIntegerPoly("1");
        if (n < 0) {
            throw new ArithmeticException("negative polynomial power " + n);
        }
        for (int i = 1; i <= n; ++i) {
            resul = resul.multiply(this);
        }
        resul.simplify();
        return resul;
    }

    public BigIntegerPoly add(BigIntegerPoly val) {
        BigIntegerPoly resul = new BigIntegerPoly();
        int nmax = this.degree() > val.degree() ? this.degree() : val.degree();
        for (int n = 0; n <= nmax; ++n) {
            BigInteger coef = this.at(n).add(val.at(n));
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public BigIntegerPoly subtract(BigIntegerPoly val) {
        BigIntegerPoly resul = new BigIntegerPoly();
        int nmax = this.degree() > val.degree() ? this.degree() : val.degree();
        for (int n = 0; n <= nmax; ++n) {
            BigInteger coef = this.at(n).subtract(val.at(n));
            resul.set(n, coef);
        }
        resul.simplify();
        return resul;
    }

    public BigIntegerPoly[] divideAndRemainder(BigIntegerPoly val) {
        BigIntegerPoly[] ret = new BigIntegerPoly[2];
        BigIntegerPoly valSimpl = val.clone();
        BigIntegerPoly thisSimpl = this.clone();
        if (valSimpl.degree() == 0 && valSimpl.a.firstElement().compareTo(BigInteger.ZERO) == 0) {
            throw new ArithmeticException("Division through zero polynomial");
        }
        if (thisSimpl.degree() < valSimpl.degree()) {
            ret[0] = new BigIntegerPoly();
            ret[1] = thisSimpl;
        } else {
            ret[0] = new BigIntegerPoly();
            BigInteger[] newc = thisSimpl.a.lastElement().divideAndRemainder(valSimpl.a.lastElement());
            if (newc[1].compareTo(BigInteger.ZERO) != 0) {
                throw new ArithmeticException("Incompatible leading term in " + this + " / " + val);
            }
            ret[0].set(thisSimpl.degree() - valSimpl.degree(), newc[0]);
            ret[1] = thisSimpl.subtract(ret[0].multiply(valSimpl));
            if (ret[1].degree() >= valSimpl.degree()) {
                BigIntegerPoly[] rem = ret[1].divideAndRemainder(val);
                ret[0] = ret[0].add(rem[0]);
                ret[1] = rem[1];
            }
        }
        return ret;
    }

    public String toString() {
        Object str = new String();
        for (int n = 0; n < this.a.size(); ++n) {
            str = n == 0 ? (String)str + this.a.elementAt(n).toString() : (String)str + "," + this.a.elementAt(n).toString();
        }
        if (((String)str).length() == 0) {
            str = "0";
        }
        return str;
    }

    public String toPString() {
        Object str = new String();
        for (int n = 0; n < this.a.size(); ++n) {
            BigInteger num = this.a.elementAt(n);
            if (num.compareTo(BigInteger.ZERO) == 0) continue;
            str = (String)str + " ";
            if (num.compareTo(BigInteger.ZERO) > 0 && n > 0) {
                str = (String)str + "+";
            }
            str = (String)str + this.a.elementAt(n).toString();
            if (n <= 0) continue;
            str = (String)str + "*x";
            if (n <= 1) continue;
            str = (String)str + "^" + n;
        }
        if (((String)str).length() == 0) {
            str = "0";
        }
        return str;
    }

    protected void simplify() {
        int n = this.a.size() - 1;
        if (n >= 0) {
            while (this.a.elementAt(n).compareTo(BigInteger.ZERO) == 0) {
                this.a.removeElementAt(n);
                if (--n >= 0) continue;
                break;
            }
        }
    }

    public BigIntegerPoly derive() {
        if (this.a.size() <= 1) {
            return new BigIntegerPoly();
        }
        BigIntegerPoly d = new BigIntegerPoly();
        for (int i = 1; i <= this.degree(); ++i) {
            BigInteger c = this.a.elementAt(i).multiply(new BigInteger("" + i));
            d.set(i - 1, c);
        }
        return d;
    }

    public BigIntegerPoly trunc(int newdeg) {
        BigIntegerPoly t = new BigIntegerPoly();
        for (int i = 0; i <= newdeg; ++i) {
            t.set(i, this.at(i));
        }
        t.simplify();
        return t;
    }

    public BigIntegerPoly binomialTInv(int maxdeg) {
        BigIntegerPoly r = new BigIntegerPoly();
        for (int i = 0; i <= maxdeg; ++i) {
            BigInteger c = BigInteger.ZERO;
            for (int j = 0; j <= i && j < this.a.size(); ++j) {
                c = (j + i) % 2 != 0 ? c.subtract(this.a.elementAt(j).multiply(BigIntegerMath.binomial(i, j))) : c.add(this.a.elementAt(j).multiply(BigIntegerMath.binomial(i, j)));
            }
            r.set(i, c);
        }
        r.simplify();
        return r;
    }

    public int rootDeg(BigInteger r) {
        int o = 0;
        BigIntegerPoly d = this.clone();
        BigInteger roo = d.valueOf(r);
        while (roo.compareTo(BigInteger.ZERO) == 0) {
            ++o;
            d = d.derive();
            roo = d.valueOf(r);
        }
        return o;
    }

    public Vector<BigInteger> iroots() {
        int l;
        Vector<BigInteger> res = new Vector<BigInteger>();
        if (this.a.firstElement().compareTo(BigInteger.ZERO) == 0) {
            res.add(BigInteger.ZERO);
        }
        if (this.a.elementAt(l = this.ldegree()).compareTo(BigInteger.ZERO) != 0) {
            Vector<BigInteger> cand = BigIntegerMath.divisors(this.a.elementAt(l).abs());
            for (int i = 0; i < cand.size(); ++i) {
                BigInteger roo = this.valueOf(cand.elementAt(i));
                if (roo.compareTo(BigInteger.ZERO) == 0) {
                    res.add(cand.elementAt(i));
                }
                if ((roo = this.valueOf(cand.elementAt(i).negate())).compareTo(BigInteger.ZERO) != 0) continue;
                res.add(cand.elementAt(i).negate());
            }
        }
        return res;
    }

    protected Vector<BigIntegerPoly> i2roots() {
        Vector<BigIntegerPoly> res = new Vector<BigIntegerPoly>();
        if (this.degree() < 2) {
            return res;
        }
        BigInteger bsco = this.a.firstElement().abs();
        Vector<BigInteger> b = BigIntegerMath.divisors(bsco);
        BigInteger csco = this.a.lastElement().abs();
        Vector<BigInteger> c = BigIntegerMath.divisors(csco);
        RatPoly thisDec = this.toRatPoly();
        Vector<BigComplex> roo = thisDec.roots(6 + (int)(0.3 * (double)bsco.bitCount()));
        BigDecimal half = new BigDecimal("0.5");
        for (BigComplex z : roo) {
            for (BigInteger bco : b) {
                for (BigInteger cco : c) {
                    if (bco.signum() == 0) continue;
                    for (int sig = -1; sig <= 1; sig += 2) {
                        BigInteger bcosig = sig > 0 ? bco : bco.negate();
                        BigDecimal negA = BigDecimalMath.add(BigDecimalMath.divideRound(bcosig, z.norm()), cco);
                        negA = negA.multiply(z.re);
                        BigInteger a = negA.negate().add(half).toBigInteger();
                        BigIntegerPoly dtst = new BigIntegerPoly(bcosig + "," + a + "," + cco);
                        try {
                            BigIntegerPoly[] rm = this.divideAndRemainder(dtst);
                            if (!rm[1].isZero()) continue;
                            res.add(dtst);
                            continue;
                        }
                        catch (ArithmeticException arithmeticException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return res;
    }

    public boolean isZero() {
        this.simplify();
        return this.a.size() == 0;
    }

    public Vector<BigIntegerPoly> ifactor() {
        Vector<BigIntegerPoly> fac = new Vector<BigIntegerPoly>();
        Vector<BigInteger> r = this.iroots();
        BigIntegerPoly[] res = new BigIntegerPoly[2];
        res[0] = this;
        for (BigInteger i : r) {
            int deg = this.rootDeg(i);
            BigIntegerPoly f = new BigIntegerPoly(i.negate() + ",1");
            for (int mu = 0; mu < deg; ++mu) {
                fac.add(f);
                res = res[0].divideAndRemainder(f);
            }
        }
        if (res[0].degree() > 0 || res[0].a.firstElement().compareTo(BigInteger.ONE) != 0) {
            fac.add(res[0]);
        }
        return fac;
    }
}

