/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ExceptionUtil;
import ar.com.sdd.commons.util.NestedException;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ejb.ApplicationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationException
public abstract class AbstractRuntimeException
extends RuntimeException
implements NestedException,
Serializable {
    private static final Logger log = LogManager.getLogger(AbstractRuntimeException.class);
    private static final long serialVersionUID = 1L;
    private static ResourceBundle resource = null;
    protected Object[] params = null;
    protected Throwable detail = null;

    public static ResourceBundle getResourceBundle() {
        return resource;
    }

    public AbstractRuntimeException() {
    }

    public AbstractRuntimeException(String msg) {
        this(msg, null, null);
    }

    public AbstractRuntimeException(String msg, Object[] params) {
        this(msg, params, null);
    }

    public AbstractRuntimeException(String msg, Object param) {
        this(msg, new Object[]{param});
    }

    public AbstractRuntimeException(String msg, Object param1, Object param2) {
        this(msg, new Object[]{param1, param2});
    }

    public AbstractRuntimeException(Throwable detail) {
        this(detail.getMessage(), null, detail);
    }

    public AbstractRuntimeException(String msg, Throwable detail) {
        this(msg, null, detail);
    }

    public AbstractRuntimeException(String msg, Object[] params, Throwable detail) {
        super(msg, detail);
        this.detail = detail;
        this.params = params;
        if (this.getLoggeable()) {
            this.dump();
        }
    }

    protected boolean getLoggeable() {
        return false;
    }

    protected boolean getFatal() {
        return false;
    }

    @Override
    public Throwable getDetail() {
        return this.detail;
    }

    public Throwable getRootDetail() {
        return ExceptionUtil.getRootException(this.getDetail());
    }

    @Override
    @Deprecated
    public String getLocalizedMessage() {
        String ret;
        block5: {
            String key = super.getMessage();
            ResourceBundle resource = AbstractRuntimeException.getResourceBundle();
            if (resource != null) {
                try {
                    if (key != null) {
                        String msg = resource.getString(key);
                        ret = msg != null ? msg : key;
                        break block5;
                    }
                    ret = key;
                }
                catch (MissingResourceException ex) {
                    ret = key;
                    log.error("Ha ocurrido un error", (Throwable)ex);
                }
            } else {
                ret = super.getMessage();
            }
        }
        return ret;
    }

    private void dump() {
        Logger log = LogManager.getLogger(this.getClass());
        if (!this.getFatal()) {
            log.error(this.getMessage(), (Throwable)this);
            if (this.getDetail() != null) {
                log.error("Causado por:", this.getDetail());
            }
        } else {
            log.fatal(this.getMessage(), (Throwable)this);
            if (this.getDetail() != null) {
                log.fatal("Causado por:", this.getDetail());
            }
        }
    }
}

