/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.Permutation;
import java.util.Iterator;
import java.util.Vector;

class Permute
implements Iterator {
    private int workptr;
    public boolean exhst;
    private Permute slav;
    private int[] orgset;

    Permute(int[] v) {
        this.init(v);
    }

    Permute(int n) {
        int[] v = new int[n];
        for (int i = 0; i < n; ++i) {
            v[i] = i + Permutation.REPOFFSET;
        }
        this.init(v);
    }

    Permute(Vector<Integer> v) {
        int[] varr = new int[v.size()];
        for (int i = 0; i < varr.length; ++i) {
            varr[i] = v.elementAt(i);
        }
        this.init(varr);
    }

    @Override
    public boolean hasNext() {
        return !this.exhst;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void init(int[] v) {
        this.workptr = 0;
        this.orgset = (int[])v.clone();
        if (v.length >= 0) {
            this.exhst = false;
            if (v.length >= 2) {
                int[] workset = new int[v.length - 1];
                for (int i = 1; i < v.length; ++i) {
                    workset[i - 1] = v[i];
                }
                this.slav = new Permute(workset);
            }
        } else {
            this.exhst = true;
        }
    }

    public int[] next() {
        int i;
        if (this.orgset.length <= 1) {
            this.exhst = true;
            return this.orgset;
        }
        if (!this.slav.exhst) {
            int[] workset = new int[this.orgset.length];
            workset[0] = this.orgset[this.workptr];
            int[] slavset = this.slav.next();
            for (int i2 = 0; i2 < slavset.length; ++i2) {
                workset[i2 + 1] = slavset[i2];
            }
            if (this.workptr == this.orgset.length - 1 && this.slav.exhst) {
                this.exhst = true;
            }
            return workset;
        }
        ++this.workptr;
        if (this.workptr >= this.orgset.length) {
            this.exhst = true;
            return new int[0];
        }
        int[] workset = new int[this.orgset.length - 1];
        for (i = 0; i < this.workptr; ++i) {
            workset[i] = this.orgset[i];
        }
        for (i = this.workptr + 1; i < this.orgset.length; ++i) {
            workset[i - 1] = this.orgset[i];
        }
        this.slav = new Permute(workset);
        return this.next();
    }

    public int[] current() {
        if (this.orgset.length <= 1) {
            return this.orgset;
        }
        int[] workset = new int[this.orgset.length];
        workset[0] = this.orgset[this.workptr];
        int[] slavset = this.slav.current();
        for (int i = 0; i < slavset.length; ++i) {
            workset[i + 1] = slavset[i];
        }
        return workset;
    }

    public String toString() {
        Object s = new String("(");
        for (int i = 0; i < this.orgset.length; ++i) {
            s = (String)s + this.orgset[i] + " ";
        }
        s = (String)s + ")";
        return s;
    }

    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        Permute p = new Permute(n);
        while (!p.exhst) {
            int[] t = p.next();
            for (int i = 0; i < n; ++i) {
                System.out.print(" " + t[i]);
            }
            System.out.println("");
        }
    }
}

